/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.graphiti.types.DataTypeAddFeature;
import eu.vicci.process.model.sofia.DataMapping;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.Transition;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class NameIDSection
extends PropertySectionBase {
    private Text nameText;
    private Text idText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.nameText = factory.createText(composite, "");
        this.nameText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addFocusListener((FocusListener)new StateFocusListener());
        this.nameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.nameText, -5);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.idText = factory.createText(composite, "");
        this.idText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.idText.setLayoutData((Object)data);
        this.idText.addFocusListener((FocusListener)new StateFocusListener());
        this.idText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "ID:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.idText, -5);
        data.top = new FormAttachment((Control)this.idText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            String name = null;
            String id = null;
            if (bo instanceof ProcessStep) {
                name = ((ProcessStep)bo).getName();
                id = ((ProcessStep)bo).getId();
            }
            if (bo instanceof Transition) {
                name = ((Transition)bo).getName();
                id = ((Transition)bo).getId();
            }
            if (bo instanceof Port) {
                name = ((Port)bo).getName();
                id = ((Port)bo).getId();
            }
            if (bo instanceof DataMapping) {
                name = ((DataMapping)bo).getName();
                id = ((DataMapping)bo).getId();
            }
            if (bo instanceof DataType) {
                name = ((DataType)bo).getName();
                id = ((DataType)bo).getId();
            }
            this.nameText.setText(name == null ? "" : name);
            this.idText.setText(id == null ? "" : id);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = NameIDSection.this.getSelectedPictogramElement();
            if (pe != null) {
                TransactionalEditingDomain editingDomain;
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof ProcessStep) {
                    editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = NameIDSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            String id;
                            String name = NameIDSection.this.nameText.getText();
                            if (name != null) {
                                org.eclipse.graphiti.mm.algorithms.Text text;
                                ((ProcessStep)bo).setName(name);
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("name")) != null) {
                                    text.setValue("name: " + name);
                                }
                            }
                            if ((id = NameIDSection.this.idText.getText()) != null) {
                                ((ProcessStep)bo).setId(id);
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
                if (bo instanceof Transition) {
                    editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = (ProcessFeatureProvider)NameIDSection.this.getDiagramTypeProvider().getFeatureProvider();
                        }

                        protected void doExecute() {
                            String id;
                            String name = NameIDSection.this.nameText.getText();
                            if (name != null) {
                                ((Transition)bo).setName(name);
                            }
                            if ((id = NameIDSection.this.nameText.getText()) != null) {
                                ((Transition)bo).setId(id);
                            }
                            Util.redrawConnectionDecorator((EObject)((Transition)bo), NameIDSection.this.getDiagram());
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
                if (bo instanceof Port) {
                    editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = NameIDSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            String id;
                            String name = NameIDSection.this.nameText.getText();
                            if (name != null) {
                                ((Port)bo).setName(name);
                            }
                            if ((id = NameIDSection.this.idText.getText()) != null) {
                                ((Port)bo).setId(id);
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
                if (bo instanceof DataMapping) {
                    editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = (ProcessFeatureProvider)NameIDSection.this.getDiagramTypeProvider().getFeatureProvider();
                        }

                        protected void doExecute() {
                            String id;
                            String name = NameIDSection.this.nameText.getText();
                            if (name != null) {
                                ((DataMapping)bo).setName(name);
                            }
                            if ((id = NameIDSection.this.nameText.getText()) != null) {
                                ((DataMapping)bo).setId(id);
                            }
                            Util.redrawConnectionDecorator((EObject)((DataMapping)bo), NameIDSection.this.getDiagram());
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
                if (bo instanceof DataType) {
                    editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = NameIDSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            String id;
                            String name = NameIDSection.this.nameText.getText();
                            if (name != null) {
                                ((DataType)bo).setName(name);
                            }
                            if ((id = NameIDSection.this.idText.getText()) != null) {
                                ((DataType)bo).setId(id);
                            }
                            DataTypeAddFeature.resizeWholeType(NameIDSection.this.getDiagram(), pe);
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

