/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.HumanTask;
import eu.vicci.process.model.sofia.HumanTaskType;
import eu.vicci.process.model.sofia.HumanTaskUseCase;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class HumanTaskSection
extends PropertySectionBase {
    private CCombo useCase;
    private CCombo type;
    private SelectionListener dropDownListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            HumanTaskSection.this.writeToModel();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createType(composite);
        this.createUseCase(composite);
    }

    private void createUseCase(Composite parent) {
        this.useCase = this.getWidgetFactory().createCCombo(parent);
        HumanTaskUseCase[] humanTaskUseCaseArray = HumanTaskUseCase.values();
        int n = humanTaskUseCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            HumanTaskUseCase val = humanTaskUseCaseArray[n2];
            this.useCase.add(val.getName());
            ++n2;
        }
        this.useCase.addSelectionListener(this.dropDownListener);
        this.useCase.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.type, 4);
        this.useCase.setLayoutData((Object)data);
        CLabel valueLabel = this.getWidgetFactory().createCLabel(parent, "Use Case:");
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)this.useCase, -5);
        labelData.top = new FormAttachment((Control)this.useCase, 0, 0x1000000);
        valueLabel.setLayoutData((Object)labelData);
    }

    private void createType(Composite parent) {
        this.type = this.getWidgetFactory().createCCombo(parent);
        HumanTaskType[] humanTaskTypeArray = HumanTaskType.values();
        int n = humanTaskTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HumanTaskType val = humanTaskTypeArray[n2];
            this.type.add(val.getName());
            ++n2;
        }
        this.type.addSelectionListener(this.dropDownListener);
        this.type.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.type.setLayoutData((Object)data);
        CLabel valueLabel = this.getWidgetFactory().createCLabel(parent, "HT Type:");
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)this.type, -5);
        labelData.top = new FormAttachment((Control)this.type, 0, 0x1000000);
        valueLabel.setLayoutData((Object)labelData);
    }

    public void refresh() {
        super.refresh();
        HumanTask ht = this.getHumanTask();
        if (ht == null) {
            return;
        }
        if (ht.getHumanTaskType() != null && this.type != null) {
            this.type.select(ht.getHumanTaskType().getValue());
        } else {
            this.type.select(0);
        }
        if (ht.getHumanTaskUseCase() != null && this.useCase != null) {
            this.useCase.select(ht.getHumanTaskUseCase().getValue());
        } else {
            this.useCase.select(0);
        }
    }

    private HumanTaskType getHtType() {
        return HumanTaskType.get((int)this.type.getSelectionIndex());
    }

    private HumanTaskUseCase getHtUseCase() {
        return HumanTaskUseCase.get((int)this.useCase.getSelectionIndex());
    }

    private HumanTask getHumanTask() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof HumanTask) {
            return (HumanTask)bo;
        }
        return null;
    }

    private void writeToModel() {
        EObject bo;
        final PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof HumanTask) {
            final HumanTask humanTask = (HumanTask)bo;
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                ProcessFeatureProvider featureProvider;
                {
                    super($anonymous0);
                    this.featureProvider = HumanTaskSection.this.getProcessFeatureProvider();
                }

                protected void doExecute() {
                    humanTask.setHumanTaskType(HumanTaskSection.this.getHtType());
                    humanTask.setHumanTaskUseCase(HumanTaskSection.this.getHtUseCase());
                    this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                }
            });
        }
    }
}

