/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.openhab.util.IOpenHabRestClient;
import eu.vicci.openhab.util.OpenHabRestClient;
import eu.vicci.process.adapter.EngineAdapter;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.GoalInvoke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class GoalInvokeSection
extends PropertySectionBase {
    private static final String LABEL_GOAL = "Invoke Goal: ";
    private static final String LABEL_LOCATION = "Location: ";
    private CCombo wGoal;
    private Section wQualitySection;
    private CCombo wLocation;
    private Composite wQualityClient;
    private Map<String, Button> qualityMap = new HashMap<String, Button>();
    private IOpenHabRestClient client;
    private Object mLock = new Object();
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GoalInvokeSection.this.writeToModel();
        }
    };

    private void addQualities() {
        List qs = this.client.getAllQualities();
        if (qs == null || qs.isEmpty()) {
            return;
        }
        qs.stream().forEach(q -> this.addQualityIfNotExists(q.name));
    }

    private void addQualityIfNotExists(String name) {
        if (name == null) {
            return;
        }
        if (this.qualityMap.containsKey(name)) {
            return;
        }
        this.addSingleQuality(name);
    }

    private void addSingleQuality(String txt) {
        this.addSingleQuality(txt, false);
    }

    private void addSingleQuality(String txt, boolean checked) {
        Button button = new Button(this.wQualityClient, 32);
        button.setLayoutData((Object)new RowData());
        button.setText(txt);
        button.addSelectionListener((SelectionListener)this.selectionAdapter);
        button.setSelection(checked);
        this.qualityMap.put(txt, button);
    }

    private void addGoals() {
        List goals = this.client.getAllGoals();
        if (goals == null || goals.isEmpty()) {
            return;
        }
        goals.stream().forEach(g -> this.addItemToCombo(this.wGoal, g.name));
    }

    private void addLocations() {
        List locs = this.client.getAllLocations();
        if (locs == null || locs.isEmpty()) {
            return;
        }
        locs.stream().forEach(l -> this.addItemToCombo(this.wLocation, l.getSemanticUri()));
    }

    private void addItemToCombo(CCombo box, String item) {
        if (item == null || item.isEmpty()) {
            return;
        }
        box.add(item);
    }

    private GoalInvoke getGoalInvoke() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (GoalInvoke)bo;
        }
        return null;
    }

    private void writeToModel() {
        final GoalInvoke goalInvoke = this.getGoalInvoke();
        if (goalInvoke == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)goalInvoke);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = GoalInvokeSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                try {
                    goalInvoke.setInvokeGoal(GoalInvokeSection.this.wGoal.getText());
                    goalInvoke.setLocation(GoalInvokeSection.this.wLocation.getText());
                    goalInvoke.getQualities().clear();
                    goalInvoke.getQualities().addAll((Collection)GoalInvokeSection.this.aggregateQualities(goalInvoke));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(GoalInvokeSection.this.getSelectedPictogramElement()));
            }
        });
    }

    private List<String> aggregateQualities(GoalInvoke goalInvoke) {
        ArrayList<String> qualities = new ArrayList<String>();
        this.qualityMap.values().stream().filter(b -> b.getSelection() && b.getText() != null && !b.getText().isEmpty()).forEach(b -> {
            boolean bl = qualities.add(b.getText());
        });
        return qualities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        super.refresh();
        Object object = this.mLock;
        synchronized (object) {
            GoalInvoke goalInvoke = this.getGoalInvoke();
            if (goalInvoke == null) {
                return;
            }
            this.wGoal.setText(goalInvoke.getInvokeGoal() == null ? "" : goalInvoke.getInvokeGoal());
            this.setQualities((EList<String>)goalInvoke.getQualities());
            this.wLocation.setText(goalInvoke.getLocation() == null ? "" : goalInvoke.getLocation());
        }
    }

    private void setQualities(EList<String> quality) {
        if (quality == null) {
            return;
        }
        quality.stream().forEach(q -> this.addQualityCheckboxOrSetValue((String)q, true));
    }

    private void addQualityCheckboxOrSetValue(String quality, boolean checked) {
        if (quality == null || quality.isEmpty()) {
            return;
        }
        Button chkBox = this.qualityMap.get(quality);
        if (chkBox == null) {
            this.addSingleQuality(quality, checked);
        } else {
            chkBox.setSelection(checked);
        }
    }

    private String getOpenHABHostFromPrefs() {
        return EngineAdapter.getDefault().getPreferenceStore().getString("pref_OpenHabHost");
    }

    private void fillDataAsync() {
        Display.getDefault().asyncExec(() -> {
            String host = this.getOpenHABHostFromPrefs();
            this.client = new OpenHabRestClient(host);
            if (this.client.getOpenHabRestVersion() == null) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.addGoals();
                this.addLocations();
                this.addQualities();
            }
            this.client.close();
        });
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite container = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout containerLayout = new GridLayout(2, true);
        container.setLayout((Layout)containerLayout);
        Composite cGoalContainer = this.getWidgetFactory().createComposite(container);
        cGoalContainer.setLayout((Layout)new GridLayout(2, false));
        GridData cGoalData = new GridData(4, 4, true, false);
        cGoalContainer.setLayoutData((Object)cGoalData);
        Label lGoal = this.getWidgetFactory().createLabel(cGoalContainer, LABEL_GOAL);
        lGoal.setLayoutData((Object)new GridData(4, 4, false, false));
        this.wGoal = this.getWidgetFactory().createCCombo(cGoalContainer, 0);
        this.wGoal.setText("Fill me with data");
        GridData gridDataGoal = new GridData(4, 4, true, false);
        this.wGoal.setLayoutData((Object)gridDataGoal);
        this.wGoal.addSelectionListener((SelectionListener)this.selectionAdapter);
        Composite cLocationContainer = this.getWidgetFactory().createComposite(container);
        cLocationContainer.setLayout((Layout)new GridLayout(2, false));
        GridData cLocationData = new GridData(4, 4, true, false);
        cLocationContainer.setLayoutData((Object)cLocationData);
        Label lLocation = this.getWidgetFactory().createLabel(cLocationContainer, LABEL_LOCATION);
        lLocation.setLayoutData((Object)new GridData(4, 4, false, false));
        this.wLocation = this.getWidgetFactory().createCCombo(cLocationContainer, 0);
        this.wLocation.setText("fill me too");
        GridData gridDataLocation = new GridData(4, 4, true, false);
        this.wLocation.setLayoutData((Object)gridDataLocation);
        this.wLocation.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.wQualitySection = this.getWidgetFactory().createSection(container, 386);
        this.wQualitySection.setText("Quality");
        GridData gridDataQuality = new GridData(4, 4, true, true);
        gridDataQuality.horizontalSpan = 2;
        this.wQualitySection.setLayoutData((Object)gridDataQuality);
        this.wQualitySection.setLayout((Layout)new FillLayout());
        this.wQualityClient = this.getWidgetFactory().createComposite((Composite)this.wQualitySection);
        this.wQualityClient.setLayout((Layout)new RowLayout(256));
        this.wQualitySection.setClient((Control)this.wQualityClient);
        this.fillData();
    }

    private void fillData() {
        this.fillDataAsync();
    }
}

