/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Condition;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.ForLoop;
import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofia.Loop;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.StartDataPort;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ForLoopSection
extends PropertySectionBase
implements FocusListener,
SelectionListener {
    private CCombo startValuePortComboBox;
    private CCombo endValuePortComboBox;
    private CCombo loopStepWidthComboBox;
    private List<StartDataPort> startDataPorts = new ArrayList<StartDataPort>();
    private TabbedPropertySheetWidgetFactory factory;
    private Composite flatFormComposite;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.factory = this.getWidgetFactory();
        this.flatFormComposite = this.factory.createFlatFormComposite(parent);
        this.setStartCCombo();
        this.setStartCLabel();
        this.setEndCCombo();
        this.setEndCLabel();
        this.setStepWidthCombo();
        this.setStepWidthLabel();
    }

    public void refresh() {
        ForLoop loop = this.getLoopElement();
        if (loop == null) {
            return;
        }
        this.fillLists((Loop)loop);
        Condition loopCondition = loop.getLoopCondition();
        if (loopCondition == null) {
            return;
        }
        this.startValuePortComboBox.select(this.startDataPorts.indexOf(loopCondition.getLeftSide()));
        this.endValuePortComboBox.select(this.startDataPorts.indexOf(loopCondition.getRightSide()));
        this.loopStepWidthComboBox.select(this.startDataPorts.indexOf(loop.getLoopStepWidth()));
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        final ForLoop loop = this.getLoopElement();
        if (loop == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)loop);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = ForLoopSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                Condition loopCondition = loop.getLoopCondition();
                try {
                    loopCondition.setLeftSide((StartDataPort)ForLoopSection.this.startDataPorts.get(ForLoopSection.this.startValuePortComboBox.getSelectionIndex()));
                    loopCondition.setRightSide((StartDataPort)ForLoopSection.this.startDataPorts.get(ForLoopSection.this.endValuePortComboBox.getSelectionIndex()));
                    loop.setLoopStepWidth((StartDataPort)ForLoopSection.this.startDataPorts.get(ForLoopSection.this.loopStepWidthComboBox.getSelectionIndex()));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(ForLoopSection.this.getSelectedPictogramElement()));
            }
        });
    }

    public void widgetSelected(SelectionEvent e) {
        this.focusLost(null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.focusLost(null);
    }

    private void fillLists(Loop loop) {
        this.endValuePortComboBox.removeAll();
        this.startValuePortComboBox.removeAll();
        this.loopStepWidthComboBox.removeAll();
        this.startDataPorts.clear();
        for (Port port : loop.getPorts()) {
            if (!(port instanceof StartDataPort) || this.startDataPorts.contains(port) || !(((StartDataPort)port).getPortDatatype() instanceof IntegerType)) continue;
            this.endValuePortComboBox.add(port.getName());
            this.startValuePortComboBox.add(port.getName());
            this.loopStepWidthComboBox.add(port.getName());
            this.startDataPorts.add((StartDataPort)port);
        }
    }

    private void setEndCCombo() {
        this.endValuePortComboBox = this.factory.createCCombo(this.flatFormComposite);
        FormData data = new FormData();
        for (DataPort dataPort : this.startDataPorts) {
            this.endValuePortComboBox.add(dataPort.getName());
        }
        data.left = new FormAttachment((Control)this.startValuePortComboBox, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.endValuePortComboBox.setLayoutData((Object)data);
        this.endValuePortComboBox.addFocusListener((FocusListener)this);
        this.endValuePortComboBox.addSelectionListener((SelectionListener)this);
    }

    private void setEndCLabel() {
        CLabel valueLabel = this.factory.createCLabel(this.flatFormComposite, "Endvalue:");
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.startValuePortComboBox, 0);
        data.right = new FormAttachment((Control)this.endValuePortComboBox, -5);
        data.top = new FormAttachment((Control)this.endValuePortComboBox, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private void setStartCLabel() {
        CLabel valueLabel = this.factory.createCLabel(this.flatFormComposite, "Startvalue:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.startValuePortComboBox, -5);
        data.top = new FormAttachment((Control)this.startValuePortComboBox, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private void setStartCCombo() {
        FormData data = new FormData();
        this.startValuePortComboBox = this.factory.createCCombo(this.flatFormComposite);
        for (DataPort dataPort : this.startDataPorts) {
            this.startValuePortComboBox.add(dataPort.getName());
        }
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, 4);
        this.startValuePortComboBox.setLayoutData((Object)data);
        this.startValuePortComboBox.addFocusListener((FocusListener)this);
        this.startValuePortComboBox.addSelectionListener((SelectionListener)this);
    }

    private void setStepWidthCombo() {
        FormData data = new FormData();
        this.loopStepWidthComboBox = this.factory.createCCombo(this.flatFormComposite);
        for (DataPort dataPort : this.startDataPorts) {
            this.loopStepWidthComboBox.add(dataPort.getName());
        }
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment((Control)this.startValuePortComboBox, 4);
        this.loopStepWidthComboBox.setLayoutData((Object)data);
        this.loopStepWidthComboBox.addFocusListener((FocusListener)this);
        this.loopStepWidthComboBox.addSelectionListener((SelectionListener)this);
    }

    private void setStepWidthLabel() {
        CLabel valueLabel = this.factory.createCLabel(this.flatFormComposite, "Step Width:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.loopStepWidthComboBox, -5);
        data.top = new FormAttachment((Control)this.loopStepWidthComboBox, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private ForLoop getLoopElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (ForLoop)bo;
        }
        return null;
    }
}

