/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.EscalationPort;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EscalationPortSection
extends PropertySectionBase {
    private Text escalationTime;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.escalationTime = factory.createText(composite, "");
        this.escalationTime.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.escalationTime.setLayoutData((Object)data);
        this.escalationTime.addFocusListener((FocusListener)new StateFocusListener());
        this.escalationTime.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Escalation Time:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.escalationTime, -5);
        data.top = new FormAttachment((Control)this.escalationTime, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            String escalationTimeString = null;
            if (bo instanceof EscalationPort) {
                escalationTimeString = String.valueOf(((EscalationPort)bo).getEscalationTime());
            }
            this.escalationTime.setText(escalationTimeString == null ? "" : escalationTimeString);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            EObject bo;
            final PictogramElement pe = EscalationPortSection.this.getSelectedPictogramElement();
            if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof EscalationPort) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                    ProcessFeatureProvider featureProvider;
                    {
                        super($anonymous0);
                        this.featureProvider = EscalationPortSection.this.getProcessFeatureProvider();
                    }

                    protected void doExecute() {
                        String escalationTimeString = EscalationPortSection.this.escalationTime.getText();
                        if (escalationTimeString != null) {
                            try {
                                ((EscalationPort)bo).setEscalationTime(Long.parseLong(escalationTimeString));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                    }
                });
            }
        }
    }
}

