/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Condition;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.If;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.StartDataPort;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ConditionOperandSection
extends PropertySectionBase {
    private CCombo leftOperand;
    private CCombo rightOperand;
    private List<StartDataPort> list = new ArrayList<StartDataPort>();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.leftOperand = factory.createCCombo(composite);
        for (DataPort dataPort : this.list) {
            this.leftOperand.add(dataPort.getName());
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, 4);
        this.leftOperand.setLayoutData((Object)data);
        this.leftOperand.addFocusListener((FocusListener)new StateFocusListener());
        this.leftOperand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new StateFocusListener().focusLost(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new StateFocusListener().focusLost(null);
            }
        });
        CLabel cLabel = factory.createCLabel(composite, "Left:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.leftOperand, -5);
        data.top = new FormAttachment((Control)this.leftOperand, 0, 0x1000000);
        cLabel.setLayoutData((Object)data);
        this.rightOperand = factory.createCCombo(composite);
        for (DataPort dataPort : this.list) {
            this.rightOperand.add(dataPort.getName());
        }
        data = new FormData();
        data.left = new FormAttachment((Control)this.leftOperand, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.rightOperand.setLayoutData((Object)data);
        this.rightOperand.addFocusListener((FocusListener)new StateFocusListener());
        this.rightOperand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new StateFocusListener().focusLost(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new StateFocusListener().focusLost(null);
            }
        });
        CLabel cLabel2 = factory.createCLabel(composite, "Right:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.leftOperand, 0);
        data.right = new FormAttachment((Control)this.rightOperand, -5);
        data.top = new FormAttachment((Control)this.rightOperand, 0, 0x1000000);
        cLabel2.setLayoutData((Object)data);
    }

    private void fillList() {
        this.list.clear();
        this.rightOperand.removeAll();
        this.leftOperand.removeAll();
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo instanceof If) {
            If iF = (If)bo;
            for (Port port : iF.getPorts()) {
                if (!(port instanceof StartDataPort) || this.list.contains(port)) continue;
                this.list.add((StartDataPort)port);
                this.rightOperand.add(port.getName());
                this.leftOperand.add(port.getName());
            }
        }
    }

    public void refresh() {
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null) {
            Condition cond;
            this.fillList();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            if (bo instanceof If && (cond = ((If)bo).getIfCondition()) != null) {
                this.leftOperand.select(this.list.indexOf(cond.getLeftSide()));
                this.rightOperand.select(this.list.indexOf(cond.getRightSide()));
            }
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            EObject bo;
            final PictogramElement pe = ConditionOperandSection.this.getSelectedPictogramElement();
            if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof If) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                    ProcessFeatureProvider featureProvider;
                    {
                        super($anonymous0);
                        this.featureProvider = ConditionOperandSection.this.getProcessFeatureProvider();
                    }

                    protected void doExecute() {
                        Condition cond = ((If)bo).getIfCondition();
                        if (cond != null) {
                            try {
                                cond.setLeftSide((StartDataPort)ConditionOperandSection.this.list.get(ConditionOperandSection.this.leftOperand.getSelectionIndex()));
                                cond.setRightSide((StartDataPort)ConditionOperandSection.this.list.get(ConditionOperandSection.this.rightOperand.getSelectionIndex()));
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        }
                        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                    }
                });
            }
        }
    }
}

