/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.types.DataTypeAddFeature;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.platform.GFPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ComplexTypeSection
extends GFPropertySection
implements ITabbedPropertyConstants {
    private static CCombo dropdown;
    private List<DataType> dataTypes = new ArrayList<DataType>();
    private Composite composite;
    private Button addButton;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.composite = factory.createFlatFormComposite(parent);
        dropdown = factory.createCCombo(this.composite);
        dropdown.removeAll();
        this.dataTypes.clear();
        for (DataType type : this.dataTypes) {
            dropdown.add(type.getName());
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment((Control)dropdown, 200);
        data.top = new FormAttachment(0, 4);
        dropdown.setLayoutData((Object)data);
        CLabel typeLabel = factory.createCLabel(this.composite, "Reference:");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)dropdown, 5);
        typeLabel.setLayoutData((Object)data);
        this.addButton = factory.createButton(this.composite, "Add", 0);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)dropdown, 0);
        data.right = new FormAttachment((Control)this.addButton, 100);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new MyClickListener());
        this.composite.layout(true, true);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof ComplexType) {
            List<DataType> types = Util.getAllReferableDataTypes(this.getDiagram(), pe);
            dropdown.removeAll();
            for (DataType type : types) {
                if (type.getName() == null || type == bo) continue;
                dropdown.add(type.getName());
            }
        }
    }

    private class MyClickListener
    implements SelectionListener {
        private MyClickListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PictogramElement pe = ComplexTypeSection.this.getSelectedPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)bo);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    PictogramElement pe = ComplexTypeSection.this.getSelectedPictogramElement();
                    EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                    List<DataType> accessibleTypes = Util.getAllReferableDataTypes(ComplexTypeSection.this.getDiagram(), pe);
                    if (bo instanceof ComplexType) {
                        ComplexType complexType = (ComplexType)bo;
                        for (DataType type : accessibleTypes) {
                            if (!type.getName().equals(dropdown.getText())) continue;
                            complexType.getSubreferences().add((Object)type);
                            DataTypeAddFeature.resizeWholeType(ComplexTypeSection.this.getDiagram(), pe);
                            break;
                        }
                    }
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

