/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.graphiti.types.DataTypeAddFeature;
import eu.vicci.process.model.sofia.CollectionType;
import eu.vicci.process.model.sofia.DataType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CollectionTypeSection
extends PropertySectionBase {
    private static CCombo dropdown;
    private List<DataType> dataTypes = new ArrayList<DataType>();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        composite.addFocusListener((FocusListener)new StateFocusListener());
        dropdown = factory.createCCombo(composite);
        dropdown.removeAll();
        this.dataTypes.clear();
        for (DataType type : this.dataTypes) {
            dropdown.add(type.getName());
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment((Control)dropdown, 200);
        data.top = new FormAttachment(0, 4);
        dropdown.setLayoutData((Object)data);
        dropdown.addFocusListener((FocusListener)new StateFocusListener());
        CLabel typeLabel = factory.createCLabel(composite, "Element Type:");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)dropdown, 5);
        typeLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof CollectionType) {
            List<DataType> types = Util.getAllReferableDataTypes(this.getDiagram(), pe);
            dropdown.removeAll();
            for (DataType type : types) {
                if (type.getName() == null || type == bo) continue;
                dropdown.add(type.getName());
            }
            CollectionType collection = (CollectionType)bo;
            if (collection.getCollectionItemType() != null) {
                String[] stringArray = dropdown.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dropdownItem = stringArray[n2];
                    if (collection.getCollectionItemType().getName().equals(dropdownItem)) {
                        dropdown.select(dropdown.indexOf(dropdownItem));
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            EObject bo;
            final PictogramElement pe = CollectionTypeSection.this.getSelectedPictogramElement();
            if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof CollectionType) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                    ProcessFeatureProvider featureProvider;
                    {
                        super($anonymous0);
                        this.featureProvider = CollectionTypeSection.this.getProcessFeatureProvider();
                    }

                    protected void doExecute() {
                        List<DataType> accessibleTypes = Util.getAllReferableDataTypes(CollectionTypeSection.this.getDiagram(), pe);
                        for (DataType type : accessibleTypes) {
                            if (!type.getName().equals(dropdown.getText())) continue;
                            ((CollectionType)bo).setCollectionItemType(type);
                            DataTypeAddFeature.resizeWholeType(CollectionTypeSection.this.getDiagram(), pe);
                            break;
                        }
                        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                    }
                });
            }
        }
    }
}

