/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature.create;

import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofia.ControlPort;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.EndPort;
import eu.vicci.process.model.sofia.Loop;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.sofia.StartPort;
import eu.vicci.process.model.sofia.Transition;
import java.util.ArrayList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class TransitionCreateFeature
extends AbstractCreateConnectionFeature {
    public TransitionCreateFeature(IFeatureProvider fp) {
        super(fp, "Transition", "Create a Transition");
    }

    private Port getState(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof Port) {
            return (Port)object;
        }
        return null;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        Port port = this.getState(context.getSourceAnchor());
        return port != null;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        Port source = this.getState(context.getSourceAnchor());
        Port target = this.getState(context.getTargetAnchor());
        if (target == null || source == target) {
            return false;
        }
        if (!(source instanceof Port) || !(target instanceof Port)) {
            return false;
        }
        Port sourceport = source;
        Port targetport = target;
        if (sourceport instanceof StartPort && !TransitionCreateFeature.canAttachStartPortToTargetPort(sourceport, targetport)) {
            return false;
        }
        if (sourceport instanceof EndPort && !TransitionCreateFeature.canAttachEndPortToTargetPort(sourceport, targetport)) {
            return false;
        }
        if (TransitionCreateFeature.hasCycle(sourceport, targetport, null)) {
            return false;
        }
        return TransitionCreateFeature.sourcePortTypeEqualsTargetPortType(source, target);
    }

    public Connection create(ICreateConnectionContext context) {
        Port source = this.getState(context.getSourceAnchor());
        Port target = this.getState(context.getTargetAnchor());
        if (source == null || target == null) {
            throw new IllegalStateException("Cannot retrieve the source or target.");
        }
        Transition transition = SofiaFactory.eINSTANCE.createTransition();
        transition.setId(EcoreUtil.generateUUID());
        transition.setName("transition");
        this.getDiagram().eResource().getContents().add((Object)transition);
        transition.setSourcePort(source);
        transition.setTargetPort(target);
        AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        addContext.setNewObject((Object)transition);
        return (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
    }

    private static boolean canAttachEndPortToTargetPort(Port sourceport, Port targetport) {
        if (targetport.getProcessStep() instanceof Process && targetport instanceof EndPort && !((Process)targetport.getProcessStep()).getSubSteps().contains((Object)sourceport.getProcessStep())) {
            return false;
        }
        if (targetport instanceof EndPort && !TransitionCreateFeature.sourceOrTargetIsSupportedProcessStep(targetport)) {
            return false;
        }
        ProcessStep sourceStep = sourceport.getProcessStep();
        CompositeStep targetParentStep = targetport.getProcessStep().getParentstep();
        if (targetParentStep == null) {
            return TransitionCreateFeature.targetIsProcess(sourceport, targetport);
        }
        if (targetport instanceof StartPort && !targetParentStep.getSubSteps().contains((Object)sourceStep)) {
            return false;
        }
        return !(targetport.getProcessStep() instanceof Loop) || !(targetport instanceof EndPort) || ((Loop)targetport.getProcessStep()).getSubSteps().contains((Object)sourceport.getProcessStep());
    }

    private static boolean canAttachStartPortToTargetPort(Port sourceport, Port targetport) {
        if (sourceport.getProcessStep() instanceof Process && !((Process)sourceport.getProcessStep()).getSubSteps().contains((Object)targetport.getProcessStep())) {
            return false;
        }
        if (sourceport.getProcessStep() instanceof Loop && !((Loop)sourceport.getProcessStep()).getSubSteps().contains((Object)targetport.getProcessStep())) {
            return false;
        }
        return TransitionCreateFeature.sourceOrTargetIsSupportedProcessStep(sourceport);
    }

    private static boolean sourceOrTargetIsSupportedProcessStep(Port port) {
        if (port.getProcessStep() instanceof Process) {
            return true;
        }
        return port.getProcessStep() instanceof Loop;
    }

    private static boolean sourcePortTypeEqualsTargetPortType(Object source, Object target) {
        return source instanceof DataPort && target instanceof DataPort || source instanceof ControlPort && target instanceof ControlPort;
    }

    private static boolean hasCycle(Port sourceport, Port targetport, ArrayList<ProcessStep> list) {
        return false;
    }

    private static boolean targetIsProcess(Port sourceport, Port targetport) {
        return targetport.getProcessStep() instanceof Process;
    }
}

