/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature.create;

import eu.vicci.process.model.sofia.CollectionType;
import eu.vicci.process.model.sofia.DataMapping;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.SofiaFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class DataMappingCreateFeature
extends AbstractCreateConnectionFeature {
    public DataMappingCreateFeature(IFeatureProvider fp) {
        super(fp, "DataMapping", "Create a DataMapping");
    }

    private DataType getState(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof DataType) {
            return (DataType)object;
        }
        return null;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        DataType type = this.getState(context.getSourceAnchor());
        return type != null;
    }

    boolean typeMapped(DataType type) {
        if (type == null) {
            return false;
        }
        if (type.getMappings().size() != 0) {
            return true;
        }
        return this.typeMapped((DataType)type.getBelongsTo());
    }

    public boolean canCreate(ICreateConnectionContext context) {
        DataType source = this.getState(context.getSourceAnchor());
        DataType target = this.getState(context.getTargetAnchor());
        if (source instanceof DataType && target instanceof DataType && source != target && source.getClass().equals(target.getClass())) {
            return true;
        }
        if (source instanceof DataType && target instanceof DataType && source != target) {
            if (source instanceof CollectionType) {
                CollectionType ct = (CollectionType)source;
                return ct.getCollectionItemType().getClass().equals(target.getClass());
            }
            return false;
        }
        return false;
    }

    public Connection create(ICreateConnectionContext context) {
        DataType source = this.getState(context.getSourceAnchor());
        DataType target = this.getState(context.getTargetAnchor());
        if (source == null || target == null) {
            throw new IllegalStateException("Cannot retrieve the source or target.");
        }
        DataMapping mapping = SofiaFactory.eINSTANCE.createDataMapping();
        mapping.setId(EcoreUtil.generateUUID());
        mapping.setName(String.valueOf(source.getName()) + " to " + target.getName());
        this.getDiagram().eResource().getContents().add((Object)mapping);
        mapping.setSource(source);
        mapping.setTarget(target);
        AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        addContext.setNewObject((Object)mapping);
        return (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
    }
}

