/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature.add;

import eu.vicci.process.model.sofia.FalseTransition;
import eu.vicci.process.model.sofia.Transition;
import eu.vicci.process.model.sofia.TrueTransition;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.IColorConstant;

public class TransitionAddFeature
extends AbstractAddFeature {
    public TransitionAddFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object obj = context.getNewObject();
        return context instanceof IAddConnectionContext && obj instanceof Transition && !(obj instanceof TrueTransition) && !(obj instanceof FalseTransition);
    }

    public PictogramElement add(IAddContext context) {
        Transition transition = (Transition)context.getNewObject();
        IGaService gaService = Graphiti.getGaService();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IAddConnectionContext addConnContext = (IAddConnectionContext)context;
        FreeFormConnection connection = Graphiti.getPeCreateService().createFreeFormConnection(this.getDiagram());
        connection.setStart(addConnContext.getSourceAnchor());
        connection.setEnd(addConnContext.getTargetAnchor());
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setLineWidth(Integer.valueOf(1));
        polyline.setForeground(this.manageColor(IColorConstant.BLACK));
        this.addArrow((Connection)connection);
        this.link((PictogramElement)connection, transition);
        ConnectionDecorator textDecorator = peCreateService.createConnectionDecorator((Connection)connection, true, 0.5, true);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)textDecorator, transition.getName());
        gaService.setLocation((GraphicsAlgorithm)text, 0, 0);
        return connection;
    }

    private Polygon addArrow(Connection connection) {
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ConnectionDecorator cd = peCreateService.createConnectionDecorator(connection, false, 1.0, true);
        IGaService gaService = Graphiti.getGaService();
        int[] nArray = new int[6];
        nArray[0] = -10;
        nArray[1] = 5;
        nArray[4] = -10;
        nArray[5] = -5;
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)cd, nArray);
        polygon.setForeground(this.manageColor(IColorConstant.BLACK));
        polygon.setBackground(this.manageColor(IColorConstant.BLACK));
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }
}

