/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature.add;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.sofiagraphics.Alignment;
import eu.vicci.process.graphiti.sofiagraphics.Color;
import eu.vicci.process.graphiti.sofiagraphics.Dimension;
import eu.vicci.process.graphiti.sofiagraphics.Gesture;
import eu.vicci.process.graphiti.sofiagraphics.Point;
import eu.vicci.process.graphiti.sofiagraphics.Polyline;
import eu.vicci.process.graphiti.sofiagraphics.Rectangle;
import eu.vicci.process.graphiti.sofiagraphics.RoundedRectangle;
import eu.vicci.process.graphiti.sofiagraphics.Scene;
import eu.vicci.process.graphiti.sofiagraphics.SofiagraphicsFactory;
import eu.vicci.process.graphiti.sofiagraphics.Style;
import eu.vicci.process.graphiti.sofiagraphics.Widget;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public abstract class SofiagraphicsAddShapeFeature
extends AbstractAddShapeFeature {
    protected Scene scene = null;
    private Vector<String> xmlGesture = new Vector();

    public SofiagraphicsAddShapeFeature(IFeatureProvider fp, String uri, String name) {
        super(fp);
        ResourceSetImpl set = new ResourceSetImpl();
        Resource resource = set.getResource(URI.createPlatformPluginURI((String)uri, (boolean)true), true);
        this.scene = (Scene)resource.getContents().get(0);
        for (Gesture gesture : this.scene.getGesture()) {
            this.addGesture(name, gesture.getWidget());
        }
    }

    public PictogramElement createGraphitiUI(IAddContext context, Widget widget, ContainerShape parent) {
        float portYPosition;
        Object object = context.getNewObject();
        IGaService ga = Graphiti.getGaService();
        IPeCreateService pe = Graphiti.getPeCreateService();
        if (parent == null) {
            parent = context.getTargetContainer();
        }
        Shape shape = null;
        Ellipse algorithm = null;
        if (!widget.isGestureOnly()) {
            if (widget.getChild() != null && widget.getChild().size() != 0) {
                shape = pe.createContainerShape(parent, false);
                pe.createChopboxAnchor((AnchorContainer)shape);
                shape.setActive(true);
            } else {
                shape = pe.createShape(parent, false);
            }
        }
        if (shape != null) {
            this.link((PictogramElement)shape, object);
        }
        if (!widget.isGestureOnly()) {
            if (widget instanceof eu.vicci.process.graphiti.sofiagraphics.Ellipse) {
                algorithm = ga.createEllipse((GraphicsAlgorithmContainer)shape);
            } else if (widget instanceof Polyline) {
                Polyline polyLine = (Polyline)widget;
                int numPoints = polyLine.getPoint().size();
                int[] pts = new int[numPoints * 2];
                int index = 0;
                while (index < numPoints) {
                    Point p = (Point)polyLine.getPoint().get(index);
                    float x = p.getX();
                    float y = p.getY();
                    if (p.isXrelative()) {
                        x *= (float)parent.getGraphicsAlgorithm().getWidth();
                    }
                    if (p.isYrelative()) {
                        y *= (float)parent.getGraphicsAlgorithm().getHeight();
                    }
                    pts[index * 2] = (int)x;
                    pts[index * 2 + 1] = (int)y;
                    ++index;
                }
                algorithm = ga.createPlainPolygon((GraphicsAlgorithmContainer)shape, pts);
            } else if (widget instanceof RoundedRectangle) {
                RoundedRectangle rectangle = (RoundedRectangle)widget;
                Dimension corners = rectangle.getCorner();
                algorithm = ga.createRoundedRectangle((GraphicsAlgorithmContainer)shape, (int)corners.getWidth(), (int)corners.getHeight());
            } else if (widget instanceof Rectangle) {
                algorithm = ga.createRectangle((GraphicsAlgorithmContainer)shape);
            } else if (widget instanceof eu.vicci.process.graphiti.sofiagraphics.Text) {
                eu.vicci.process.graphiti.sofiagraphics.Text text = (eu.vicci.process.graphiti.sofiagraphics.Text)widget;
                algorithm = ga.createText((GraphicsAlgorithmContainer)shape, text.getText());
                Alignment halign = text.getHalign();
                Alignment valign = text.getValign();
                if (halign != null) {
                    ((Text)algorithm).setHorizontalAlignment(Orientation.get((int)halign.getValue()));
                }
                if (valign != null) {
                    ((Text)algorithm).setVerticalAlignment(Orientation.get((int)valign.getValue()));
                }
                ((Text)algorithm).setFont(ga.manageDefaultFont(this.getDiagram(), false, true));
                String att = text.getAttributeName();
                if (att != null) {
                    AttributeMap.instance().addObjectMapItem(object, att, (Text)algorithm);
                }
            }
        }
        Point pos = widget.getPos();
        Dimension dim = widget.getDim();
        if (algorithm != null) {
            if (pos != null) {
                ga.setLocation((GraphicsAlgorithm)algorithm, (int)pos.getX(), (int)pos.getY());
            }
            if (dim != null) {
                float width = dim.getWidth();
                float height = dim.getHeight();
                if (dim.isWrelative()) {
                    width *= (float)parent.getGraphicsAlgorithm().getWidth();
                }
                if (dim.isHrelative()) {
                    height *= (float)parent.getGraphicsAlgorithm().getHeight();
                }
                ga.setSize((GraphicsAlgorithm)algorithm, (int)width, (int)height);
            }
        }
        Style style = widget.getStyle();
        if (algorithm != null && style != null) {
            Color fgColor = style.getFgcolor();
            Color bgColor = style.getBgcolor();
            float lineWidth = style.getLineWidth();
            algorithm.setFilled(Boolean.valueOf(style.isFilled()));
            algorithm.setLineWidth(Integer.valueOf((int)lineWidth));
            if (fgColor != null) {
                algorithm.setForeground(this.manageColor((IColorConstant)new ColorConstant((int)fgColor.getR() * 255, (int)fgColor.getG() * 255, (int)fgColor.getB() * 255)));
            }
            if (bgColor != null) {
                algorithm.setBackground(this.manageColor((IColorConstant)new ColorConstant((int)bgColor.getR() * 255, (int)bgColor.getG() * 255, (int)bgColor.getB() * 255)));
                double transparency = bgColor.getA();
                algorithm.setTransparency(Double.valueOf(transparency));
            }
        }
        if (algorithm != null && parent == context.getTargetContainer()) {
            ga.setLocation((GraphicsAlgorithm)algorithm, context.getX(), context.getY());
            if (dim == null || !dim.isNoresize()) {
                if (context.getWidth() != -1) {
                    ga.setWidth((GraphicsAlgorithm)algorithm, context.getWidth());
                }
                if (context.getHeight() != -1) {
                    ga.setHeight((GraphicsAlgorithm)algorithm, context.getHeight());
                }
            }
        }
        if (shape != null && (portYPosition = widget.getPortYPosition()) != 0.0f) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)shape, "portYPosition", "" + portYPosition);
        }
        for (Widget child : widget.getChild()) {
            this.createGraphitiUI(context, child, (ContainerShape)shape);
        }
        if (shape != null) {
            return shape;
        }
        return parent;
    }

    private void addGesture(String name, EList<Widget> widgets) {
        StringBuffer buf = new StringBuffer();
        buf.append("<Gesture Name=\"" + name + "\" Subject=\"test\" Speed=\"test\">\n");
        int index = 1;
        for (Widget widget : widgets) {
            buf.append(" <Stroke index=\"" + index++ + "\">\n");
            if (widget instanceof Polyline) {
                Polyline line = (Polyline)widget;
                EList<Point> points = line.getPoint();
                int num = 20;
                int p = 0;
                while (p < points.size() - 1) {
                    Point a = (Point)points.get(p);
                    Point b = (Point)points.get(p + 1);
                    float dx = (b.getX() - a.getX()) / (float)num;
                    float dy = (b.getY() - a.getY()) / (float)num;
                    int i = 0;
                    while (i < num) {
                        buf.append("<Point X=\"" + (int)(a.getX() + (float)i * dx) + "\"" + " Y=\"" + (int)(a.getY() + (float)i * dy) + "\" T=\"0\"/>\n");
                        ++i;
                    }
                    ++p;
                }
            } else if (widget instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)widget;
                Point pos = rectangle.getPos();
                Dimension dim = rectangle.getDim();
                ArrayList<Point> points = new ArrayList<Point>();
                Point p00 = SofiagraphicsFactory.eINSTANCE.createPoint();
                p00.setX(pos.getX());
                p00.setY(pos.getY());
                Point p10 = SofiagraphicsFactory.eINSTANCE.createPoint();
                p10.setX(pos.getX() + dim.getWidth());
                p10.setY(pos.getY());
                Point p11 = SofiagraphicsFactory.eINSTANCE.createPoint();
                p11.setX(pos.getX() + dim.getWidth());
                p11.setY(pos.getY() + dim.getHeight());
                Point p01 = SofiagraphicsFactory.eINSTANCE.createPoint();
                p01.setX(pos.getX());
                p01.setY(pos.getY() + dim.getHeight());
                points.add(p00);
                points.add(p10);
                points.add(p11);
                points.add(p01);
                points.add(p00);
                int num = 20;
                int p = 0;
                while (p < points.size() - 1) {
                    Point a = (Point)points.get(p);
                    Point b = (Point)points.get(p + 1);
                    float dx = (b.getX() - a.getX()) / (float)num;
                    float dy = (b.getY() - a.getY()) / (float)num;
                    int i = 0;
                    while (i < num) {
                        buf.append("<Point X=\"" + (int)(a.getX() + (float)i * dx) + "\"" + " Y=\"" + (int)(a.getY() + (float)i * dy) + "\" T=\"0\"/>\n");
                        ++i;
                    }
                    ++p;
                }
            } else if (widget instanceof eu.vicci.process.graphiti.sofiagraphics.Ellipse) {
                int num = 48;
                int n = 0;
                while (n < num + 1) {
                    double deg = Math.PI * 2 / (double)num * (double)n;
                    double x = 100.0 * Math.cos(deg) + 100.0;
                    double y = 100.0 * Math.sin(deg) + 100.0;
                    buf.append("<Point X=\"" + (int)x + "\"" + " Y=\"" + (int)y + "\" T=\"0\"/>\n");
                    ++n;
                }
            }
            buf.append(" </Stroke>\n");
        }
        buf.append(" </Gesture>\n");
        this.xmlGesture.add(buf.toString());
    }

    public PictogramElement add(IAddContext context) {
        PictogramElement element = this.createGraphitiUI(context, this.scene.getRoot(), null);
        return element;
    }
}

