/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature.add;

import eu.vicci.process.graphiti.AttributeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public abstract class PictogramAddShapeFeature
extends AbstractAddShapeFeature {
    private Vector<String> xmlGestures = null;
    private Map<Integer, Vector<String>> strokesMap = null;
    private String sceneUri;
    private String name;

    public PictogramAddShapeFeature(IFeatureProvider fp, String uri, String name) {
        super(fp);
        this.sceneUri = uri;
        this.name = name;
    }

    private void linkRecursive(Shape shape, Object object) {
        this.link((PictogramElement)shape, object);
        if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                this.linkRecursive(child, object);
            }
        }
    }

    private void setSize(Shape shape, int width, int height) {
        String r = Graphiti.getPeService().getPropertyValue((PropertyContainer)shape.getGraphicsAlgorithm(), "resizable");
        if (r != null && r.contains("width")) {
            shape.getGraphicsAlgorithm().setWidth(width);
        }
        if (r != null && r.contains("height")) {
            shape.getGraphicsAlgorithm().setHeight(height);
        }
        if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                this.setSize(child, width, height);
            }
        }
    }

    private void addAttributes(Shape shape, Object object) {
        if (shape.getGraphicsAlgorithm() instanceof Text) {
            String name = Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "name");
            if (name != null) {
                AttributeMap.instance().addObjectMapItem(object, name, (Text)shape.getGraphicsAlgorithm());
            }
        } else if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                this.addAttributes(child, object);
            }
        }
    }

    private void manageChildColors(Shape shape) {
        Color foreground = shape.getGraphicsAlgorithm().getForeground();
        Color background = shape.getGraphicsAlgorithm().getBackground();
        if (foreground != null) {
            shape.getGraphicsAlgorithm().setForeground(this.manageColor(foreground.getRed(), foreground.getGreen(), foreground.getBlue()));
        }
        if (background != null) {
            shape.getGraphicsAlgorithm().setBackground(this.manageColor(background.getRed(), background.getGreen(), background.getBlue()));
        }
        if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                this.manageChildColors(child);
            }
        }
    }

    public PictogramElement add(IAddContext context) {
        IGaService ga = Graphiti.getGaService();
        ContainerShape parent = context.getTargetContainer();
        ResourceSetImpl set = new ResourceSetImpl();
        Resource resource = set.getResource(URI.createPlatformPluginURI((String)this.sceneUri, (boolean)true), true);
        Diagram dia = (Diagram)resource.getContents().get(0);
        Shape child = (Shape)dia.getChildren().get(0);
        ga.setLocation(child.getGraphicsAlgorithm(), context.getX(), context.getY());
        if (context.getWidth() != -1 && context.getHeight() != -1) {
            this.setSize(child, context.getWidth(), context.getHeight());
        }
        this.linkRecursive(child, context.getNewObject());
        this.addAttributes(child, context.getNewObject());
        this.manageChildColors(child);
        child.setContainer(parent);
        parent.eResource().getResourceSet().getResources().add((Object)resource);
        return child;
    }

    public Vector<String> getXMLGestures() {
        if (this.xmlGestures == null) {
            ResourceSetImpl set = new ResourceSetImpl();
            Resource resource = set.getResource(URI.createPlatformPluginURI((String)this.sceneUri, (boolean)true), true);
            ContainerShape shape = (ContainerShape)resource.getContents().get(0);
            this.strokesMap = new HashMap<Integer, Vector<String>>();
            this.xmlGestures = new Vector();
            this.addGestures((Shape)shape);
            for (Vector<String> strokes : this.strokesMap.values()) {
                StringBuffer buf = new StringBuffer();
                buf.append("<Gesture Name=\"" + this.name + "\" Subject=\"test\" Speed=\"test\">\n");
                for (String stroke : strokes) {
                    buf.append(stroke);
                }
                buf.append("</Gesture>");
                this.xmlGestures.add(buf.toString());
            }
        }
        return this.xmlGestures;
    }

    private void addGestures(Shape shape) {
        for (Property property : shape.getProperties()) {
            if (!property.getKey().equals("gesture")) continue;
            int index = Integer.parseInt(property.getValue());
            Vector<String> strokes = this.strokesMap.get(index);
            if (strokes == null) {
                strokes = new Vector();
                this.strokesMap.put(index, strokes);
            }
            int strokeIndex = strokes.size();
            StringBuffer buf = new StringBuffer();
            buf.append(" <Stroke index=\"" + (strokeIndex + 1) + "\">\n");
            if (shape.getGraphicsAlgorithm() instanceof Polyline) {
                Polyline line = (Polyline)shape.getGraphicsAlgorithm();
                EList points = line.getPoints();
                int num = 20;
                int p = 0;
                while (p < points.size() - 1) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point a = (org.eclipse.graphiti.mm.algorithms.styles.Point)points.get(p);
                    org.eclipse.graphiti.mm.algorithms.styles.Point b = (org.eclipse.graphiti.mm.algorithms.styles.Point)points.get(p + 1);
                    float dx = (b.getX() - a.getX()) / num;
                    float dy = (b.getY() - a.getY()) / num;
                    int i = 0;
                    while (i < num) {
                        buf.append("<Point X=\"" + (int)((float)a.getX() + (float)i * dx) + "\"" + " Y=\"" + (int)((float)a.getY() + (float)i * dy) + "\" T=\"0\"/>\n");
                        ++i;
                    }
                    ++p;
                }
            } else if (shape.getGraphicsAlgorithm() instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)shape.getGraphicsAlgorithm();
                Point pos = new Point(rectangle.getX(), rectangle.getY());
                Point dim = new Point(rectangle.getWidth(), rectangle.getHeight());
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(new Point(pos.x, pos.y));
                points.add(new Point(pos.x + dim.x, pos.y));
                points.add(new Point(pos.x + dim.x, pos.y + dim.y));
                points.add(new Point(pos.x, pos.y + dim.y));
                points.add(new Point(pos.x, pos.y));
                int num = 20;
                int p = 0;
                while (p < points.size() - 1) {
                    Point a = (Point)points.get(p);
                    Point b = (Point)points.get(p + 1);
                    float dx = (float)(b.x - a.x) / (float)num;
                    float dy = (float)(b.y - a.y) / (float)num;
                    int i = 0;
                    while (i < num) {
                        buf.append("<Point X=\"" + (int)((float)a.x + (float)i * dx) + "\"" + " Y=\"" + (int)((float)a.y + (float)i * dy) + "\" T=\"0\"/>\n");
                        ++i;
                    }
                    ++p;
                }
            } else if (shape.getGraphicsAlgorithm() instanceof Ellipse) {
                int num = 32;
                int n = 0;
                while (n < num + 1) {
                    double deg = Math.PI * 2 / (double)num * (double)n;
                    double x = 100.0 * Math.cos(deg) + 600.0;
                    double y = 100.0 * Math.sin(deg) + 600.0;
                    buf.append("<Point X=\"" + (int)x + "\"" + " Y=\"" + (int)y + "\" T=\"0\"/>\n");
                    ++n;
                }
            }
            buf.append(" </Stroke>\n");
            strokes.add(buf.toString());
        }
        if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                this.addGestures(child);
            }
        }
    }

    private class Point {
        public int x;
        public int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

