/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.feature;

import eu.vicci.process.model.sofia.HTTPverb;
import eu.vicci.process.model.sofia.OSGiInvoke;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.RESTInvoke;
import eu.vicci.process.model.sofia.ROSInvoke;
import eu.vicci.process.model.sofia.SOAPInvoke;
import eu.vicci.process.model.sofia.SeMiWaInvoke;
import eu.vicci.process.model.sofia.SeMiWaRequest;
import eu.vicci.process.model.sofia.TriggeredEvent;
import eu.vicci.process.model.sofia.XMLRPCInvoke;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DirectEditFeature
extends AbstractDirectEditingFeature {
    private String propertyTitle;

    public DirectEditFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return bo instanceof ProcessStep && ga instanceof Text;
    }

    public String getInitialValue(IDirectEditingContext context) {
        String string = "";
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        if (ga instanceof Text) {
            for (Property prop : ga.getProperties()) {
                if (!prop.getKey().equals("name")) continue;
                string = ((Text)ga).getValue();
                this.propertyTitle = prop.getValue();
                string = string.replaceFirst(String.valueOf(this.propertyTitle) + ":", "");
                string = string.trim();
                break;
            }
        }
        return string;
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value.contains("\n")) {
            return "Line breakes are not allowed in task names.";
        }
        return null;
    }

    public void setValue(String value, IDirectEditingContext context) {
        OSGiInvoke inv;
        PictogramElement pe = context.getPictogramElement();
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        ProcessStep task = (ProcessStep)this.getBusinessObjectForPictogramElement(pe);
        if (this.propertyTitle.equals("name")) {
            task.setName(value);
        }
        if (this.propertyTitle.equals("type")) {
            task.setType(value);
        }
        if (this.propertyTitle.equals("resource")) {
            task.setResource(value);
        }
        if (task instanceof OSGiInvoke) {
            inv = (OSGiInvoke)task;
            if (this.propertyTitle.equals("service")) {
                inv.setServiceClassName(value);
            }
            if (this.propertyTitle.equals("method")) {
                inv.setMethodName(value);
            }
            if (this.propertyTitle.equals("parameter")) {
                inv.setParameterTypes(value);
            }
            if (this.propertyTitle.equals("bundle")) {
                inv.setBundleName(value);
            }
        }
        if (task instanceof SOAPInvoke) {
            inv = (SOAPInvoke)task;
            if (this.propertyTitle.equals("server")) {
                inv.setServerUri(value);
            }
            if (this.propertyTitle.equals("method")) {
                inv.setMethodName(value);
            }
            if (this.propertyTitle.equals("wsdl")) {
                inv.setWsdlUri(value);
            }
            if (this.propertyTitle.equals("config")) {
                inv.setConfigFile(value);
            }
        }
        if (task instanceof RESTInvoke) {
            inv = (RESTInvoke)task;
            if (this.propertyTitle.equals("server")) {
                inv.setServerUri(value);
            }
            if (this.propertyTitle.equals("method")) {
                inv.setHTTPMethod(HTTPverb.get((String)value));
            }
        }
        if (task instanceof ROSInvoke) {
            inv = (ROSInvoke)task;
            if (this.propertyTitle.equals("server")) {
                inv.setServerUri(value);
            }
            if (this.propertyTitle.equals("service")) {
                inv.setServiceName(value);
            }
        }
        if (task instanceof XMLRPCInvoke) {
            inv = (XMLRPCInvoke)task;
            if (this.propertyTitle.equals("server")) {
                inv.setServerUri(value);
            }
            if (this.propertyTitle.equals("method")) {
                inv.setMethodName(value);
            }
            if (this.propertyTitle.equals("start sequence")) {
                inv.setStartParameterSequence(value);
            }
            if (this.propertyTitle.equals("end sequence")) {
                inv.setEndParameterSequence(value);
            }
        }
        if (task instanceof SeMiWaInvoke) {
            inv = (SeMiWaInvoke)task;
            if (this.propertyTitle.equals("service")) {
                inv.setServiceName(value);
            }
            if (this.propertyTitle.equals("nodeID")) {
                inv.setNodeId(value);
            }
        }
        if (task instanceof SeMiWaRequest) {
            SeMiWaRequest req = (SeMiWaRequest)task;
            if (this.propertyTitle.equals("ssil")) {
                req.setSSILStatement(value);
            }
        }
        if (task instanceof TriggeredEvent) {
            TriggeredEvent evt = (TriggeredEvent)task;
            if (this.propertyTitle.equals("EPL")) {
                evt.setEPLStatement(value);
            }
        }
        if (this.propertyTitle != null && !this.propertyTitle.equals("") && ga instanceof Text) {
            ((Text)ga).setValue(String.valueOf(this.propertyTitle) + ": " + value);
        }
        this.updatePictogramElement((PictogramElement)((Shape)pe).getContainer());
    }
}

