/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti;

import com.predic8.schema.ComplexType;
import com.predic8.schema.Element;
import com.predic8.schema.Schema;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.WSDLParser;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.types.BooleanTypeCreateFeature;
import eu.vicci.process.graphiti.types.ComplexTypeCreateFeature;
import eu.vicci.process.graphiti.types.DoubleTypeCreateFeature;
import eu.vicci.process.graphiti.types.IntegerTypeCreateFeature;
import eu.vicci.process.graphiti.types.StringTypeCreateFeature;
import eu.vicci.process.model.sofia.BooleanType;
import eu.vicci.process.model.sofia.DoubleType;
import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofia.StringType;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public class WsdlTypeImporter {
    public static void parse(final String wsdlUri, final ProcessFeatureProvider pfp, final ContainerShape target, final Diagram diagram) {
        if (wsdlUri.length() > 3 && wsdlUri.toLowerCase().contains("wsdl")) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)target);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)bo);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    WSDLParser parser = new WSDLParser();
                    Definitions defs = parser.parse(wsdlUri);
                    int yPosition = 30;
                    for (Schema schema : defs.getSchemas()) {
                        for (ComplexType ct : schema.getComplexTypes()) {
                            System.out.println(ct.getName());
                            eu.vicci.process.model.sofia.ComplexType ctObject = WsdlTypeImporter.createComplexType(pfp, target, ct.getName());
                            for (Element elem : ct.getSequence().getElements()) {
                                if (elem.getType().getLocalPart().toLowerCase().equals("string")) {
                                    WsdlTypeImporter.createStringType(pfp, Util.getContainerForBusinessObject(diagram, ctObject), elem.getName());
                                }
                                if (elem.getType().getLocalPart().toLowerCase().equals("integer")) {
                                    WsdlTypeImporter.createIntegerType(pfp, Util.getContainerForBusinessObject(diagram, ctObject), elem.getName());
                                }
                                if (elem.getType().getLocalPart().toLowerCase().equals("double")) {
                                    WsdlTypeImporter.createDoubleType(pfp, Util.getContainerForBusinessObject(diagram, ctObject), elem.getName());
                                }
                                if (!elem.getType().getLocalPart().toLowerCase().equals("boolean")) continue;
                                WsdlTypeImporter.createBooleanType(pfp, Util.getContainerForBusinessObject(diagram, ctObject), elem.getName());
                            }
                            GraphicsAlgorithm ga = Util.getContainerForBusinessObject(diagram, ctObject).getGraphicsAlgorithm();
                            ga.setX(target.getGraphicsAlgorithm().getWidth() - ga.getWidth() - 10);
                            ga.setY(yPosition);
                            yPosition += ga.getHeight() + 10;
                        }
                    }
                    target.getGraphicsAlgorithm().setHeight(Math.max(target.getGraphicsAlgorithm().getHeight(), yPosition));
                }
            });
        }
    }

    protected static void createIntegerType(ProcessFeatureProvider pfp, ContainerShape target, String name) {
        IntegerTypeCreateFeature itc = new IntegerTypeCreateFeature((IFeatureProvider)pfp);
        CreateContext context = new CreateContext();
        IntegerType it = (IntegerType)itc.create((ICreateContext)context)[0];
        ILinkService ls = Graphiti.getLinkService();
        EObject parent = ls.getBusinessObjectForLinkedPictogramElement((PictogramElement)target);
        if (parent instanceof eu.vicci.process.model.sofia.ComplexType) {
            it.setBelongsTo((eu.vicci.process.model.sofia.ComplexType)parent);
        }
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)it);
        addContext.setTargetContainer(target);
        IAddFeature add = pfp.getAddFeature((IAddContext)addContext);
        if (addContext != null && add != null) {
            add.add((IAddContext)addContext);
        }
    }

    protected static void createDoubleType(ProcessFeatureProvider pfp, ContainerShape target, String name) {
        DoubleTypeCreateFeature dtc = new DoubleTypeCreateFeature((IFeatureProvider)pfp);
        CreateContext context = new CreateContext();
        DoubleType dt = (DoubleType)dtc.create((ICreateContext)context)[0];
        dt.setName(name);
        ILinkService ls = Graphiti.getLinkService();
        EObject parent = ls.getBusinessObjectForLinkedPictogramElement((PictogramElement)target);
        if (parent instanceof eu.vicci.process.model.sofia.ComplexType) {
            dt.setBelongsTo((eu.vicci.process.model.sofia.ComplexType)parent);
        }
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)dt);
        addContext.setTargetContainer(target);
        IAddFeature add = pfp.getAddFeature((IAddContext)addContext);
        if (addContext != null && add != null) {
            add.add((IAddContext)addContext);
        }
    }

    protected static void createStringType(ProcessFeatureProvider pfp, ContainerShape target, String name) {
        StringTypeCreateFeature stc = new StringTypeCreateFeature((IFeatureProvider)pfp);
        CreateContext context = new CreateContext();
        StringType st = (StringType)stc.create((ICreateContext)context)[0];
        st.setName(name);
        ILinkService ls = Graphiti.getLinkService();
        EObject parent = ls.getBusinessObjectForLinkedPictogramElement((PictogramElement)target);
        if (parent instanceof eu.vicci.process.model.sofia.ComplexType) {
            st.setBelongsTo((eu.vicci.process.model.sofia.ComplexType)parent);
        }
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)st);
        addContext.setTargetContainer(target);
        IAddFeature add = pfp.getAddFeature((IAddContext)addContext);
        if (addContext != null && add != null) {
            add.add((IAddContext)addContext);
        }
    }

    protected static void createBooleanType(ProcessFeatureProvider pfp, ContainerShape target, String name) {
        BooleanTypeCreateFeature btc = new BooleanTypeCreateFeature((IFeatureProvider)pfp);
        CreateContext context = new CreateContext();
        BooleanType bt = (BooleanType)btc.create((ICreateContext)context)[0];
        bt.setName(name);
        ILinkService ls = Graphiti.getLinkService();
        EObject parent = ls.getBusinessObjectForLinkedPictogramElement((PictogramElement)target);
        if (parent instanceof eu.vicci.process.model.sofia.ComplexType) {
            bt.setBelongsTo((eu.vicci.process.model.sofia.ComplexType)parent);
        }
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)bt);
        addContext.setTargetContainer(target);
        IAddFeature add = pfp.getAddFeature((IAddContext)addContext);
        if (addContext != null && add != null) {
            add.add((IAddContext)addContext);
        }
    }

    private static eu.vicci.process.model.sofia.ComplexType createComplexType(ProcessFeatureProvider pfp, ContainerShape target, String name) {
        ComplexTypeCreateFeature ctc = new ComplexTypeCreateFeature((IFeatureProvider)pfp);
        CreateContext context = new CreateContext();
        eu.vicci.process.model.sofia.ComplexType ct = (eu.vicci.process.model.sofia.ComplexType)ctc.create((ICreateContext)context)[0];
        ct.setName(name);
        ILinkService ls = Graphiti.getLinkService();
        EObject parent = ls.getBusinessObjectForLinkedPictogramElement((PictogramElement)target);
        if (parent instanceof eu.vicci.process.model.sofia.ComplexType) {
            ct.setBelongsTo((eu.vicci.process.model.sofia.ComplexType)parent);
        }
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)ct);
        addContext.setTargetContainer(target);
        IAddFeature add = pfp.getAddFeature((IAddContext)addContext);
        if (addContext != null && add != null) {
            add.add((IAddContext)addContext);
        }
        return ct;
    }
}

