/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti;

import eu.vicci.process.graphiti.AttributeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;

public class SofiaPersistencyBehavior
extends DefaultPersistencyBehavior {
    public SofiaPersistencyBehavior(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
    }

    public Diagram loadDiagram(URI uri) {
        AttributeMap.instance().clear();
        Diagram diagram = super.loadDiagram(uri);
        if (diagram == null) {
            return null;
        }
        EList links = diagram.getPictogramLinks();
        for (PictogramLink link : links) {
            PictogramElement element = link.getPictogramElement();
            EList propertyList = element.getGraphicsAlgorithm().getProperties();
            Text text = null;
            String key = null;
            for (Property property : propertyList) {
                if (!property.getKey().equals("name") || !(element.getGraphicsAlgorithm() instanceof Text)) continue;
                key = property.getValue();
                text = (Text)element.getGraphicsAlgorithm();
            }
            EList objects = link.getBusinessObjects();
            for (EObject object : objects) {
                if (key == null || text == null) continue;
                AttributeMap.instance().addObjectMapItem(object, key, text, false);
            }
        }
        return diagram;
    }
}

