/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti;

import eu.vicci.process.graphiti.ReadOnlyFeatureChecker;
import eu.vicci.process.graphiti.feature.ProcessClickedFeature;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.ProcessStep;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureChecker;
import org.eclipse.graphiti.features.IFeatureCheckerHolder;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ISingleClickContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;

public class ReadOnlyToolBehaviorProvider
extends DefaultToolBehaviorProvider
implements IFeatureCheckerHolder {
    private ReadOnlyFeatureChecker featureChecker;
    private SingleClickFeature singleClickFeature;

    public ReadOnlyToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
    }

    public ICustomFeature getSingleClickFeature(ISingleClickContext context) {
        if (this.singleClickFeature == null) {
            this.singleClickFeature = new SingleClickFeature(this.getFeatureProvider());
        }
        return this.singleClickFeature;
    }

    public IFeatureChecker getFeatureChecker() {
        if (this.featureChecker == null) {
            this.featureChecker = new ReadOnlyFeatureChecker();
        }
        return this.featureChecker;
    }

    private static class SingleClickFeature
    extends AbstractCustomFeature {
        public SingleClickFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canExecute(ICustomContext context) {
            if (context.getPictogramElements().length != 1) {
                return false;
            }
            Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
            return this.isSupportedBusinessObject(bo);
        }

        public void execute(ICustomContext context) {
            Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
            String id = this.getSelectedProcessId(bo);
            if (id == null) {
                return;
            }
            ProcessClickedFeature clickedFeature = new ProcessClickedFeature(this.getFeatureProvider(), id);
            this.getDiagramBehavior().executeFeature((IFeature)clickedFeature, (IContext)context);
        }

        private String getSelectedProcessId(Object bo) {
            ProcessStep step;
            if (bo instanceof Port && (step = ((Port)bo).getProcessStep()) != null) {
                return step.getId();
            }
            if (bo instanceof ProcessStep) {
                return ((ProcessStep)bo).getId();
            }
            return null;
        }

        private boolean isSupportedBusinessObject(Object bo) {
            return bo instanceof ProcessStep || bo instanceof Port;
        }
    }
}

