/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VicciMainTab
extends AbstractLaunchConfigurationTab {
    public static final String TAB_NAME = "Main Runtime Configuration";
    public static final String ID = "eu.vicci.process.graphiti.execution.launch.vicciMainTab";
    public static final String CFG_FILE = "File";
    public static final String CFG_PROJECT = "Project";
    public static final String CFG_RUN_IN_LOOP = "RunInLoop";
    public static final String DEFAULT_FILE = "";
    public static final String DEFAULT_PROJECT = "";
    public static final boolean DEFAULT_RUN_IN_LOOP = false;
    private Text fFileText;
    private Text fProjectText;
    private Button fRunInLoop;
    private Label projTextLabel;
    private Label fileTextLabel;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            VicciMainTab.this.scheduleUpdateJob();
        }
    };

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new FormLayout());
        this.createProjectTextComponent(comp);
        this.createFileTextComponent(comp);
        this.createRunInLoopComponent(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setContainer(null);
        configuration.setAttribute(CFG_FILE, "");
        configuration.setAttribute(CFG_PROJECT, "");
        configuration.setAttribute(CFG_RUN_IN_LOOP, false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fProjectText.setText(VicciMainTab.getProjectFromConfig(configuration));
        this.fFileText.setText(VicciMainTab.getFileFromConfig(configuration));
        this.fRunInLoop.setSelection(VicciMainTab.getRunInLoopFromConfig(configuration));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(CFG_FILE, this.fFileText.getText());
        configuration.setAttribute(CFG_PROJECT, this.fProjectText.getText());
        configuration.setAttribute(CFG_RUN_IN_LOOP, this.fRunInLoop.getSelection());
    }

    public String getName() {
        return TAB_NAME;
    }

    public String getId() {
        return ID;
    }

    public static String getStringValueFromConfig(String attribute, String defaultValue, ILaunchConfiguration configuration) {
        String config = defaultValue;
        try {
            config = configuration.getAttribute(attribute, defaultValue);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static boolean getBooleanValueFromConfig(String attribute, boolean defaultValue, ILaunchConfiguration configuration) {
        boolean config = defaultValue;
        try {
            config = configuration.getAttribute(attribute, defaultValue);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static String getFileFromConfig(ILaunchConfiguration configuration) {
        return VicciMainTab.getStringValueFromConfig(CFG_FILE, "", configuration);
    }

    public static String getProjectFromConfig(ILaunchConfiguration configuration) {
        return VicciMainTab.getStringValueFromConfig(CFG_PROJECT, "", configuration);
    }

    public static boolean getRunInLoopFromConfig(ILaunchConfiguration configuration) {
        return VicciMainTab.getBooleanValueFromConfig(CFG_RUN_IN_LOOP, false, configuration);
    }

    private void createFileTextComponent(Composite parent) {
        this.fFileText = new Text(parent, 2052);
        this.fileTextLabel = new Label(parent, 0x1000000);
        this.fileTextLabel.setText(CFG_FILE);
        FormData fd_fileTextLabel = new FormData();
        fd_fileTextLabel.top = new FormAttachment((Control)this.projTextLabel, 16);
        fd_fileTextLabel.left = new FormAttachment(0, 10);
        this.fileTextLabel.setLayoutData((Object)fd_fileTextLabel);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)this.fileTextLabel, 73);
        formData2.top = new FormAttachment((Control)this.fileTextLabel, 0, 128);
        formData2.right = new FormAttachment(100, -10);
        this.fFileText.setLayoutData((Object)formData2);
        this.fFileText.addModifyListener(this.fBasicModifyListener);
    }

    private void createProjectTextComponent(Composite parent) {
        this.fProjectText = new Text(parent, 2052);
        this.projTextLabel = new Label(parent, 0x1000000);
        this.projTextLabel.setText(CFG_PROJECT);
        FormData fd_projTextLabel = new FormData();
        fd_projTextLabel.top = new FormAttachment(0, 10);
        fd_projTextLabel.left = new FormAttachment(0, 10);
        this.projTextLabel.setLayoutData((Object)fd_projTextLabel);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)this.projTextLabel, 54);
        formData2.top = new FormAttachment((Control)this.projTextLabel, 0, 128);
        formData2.right = new FormAttachment(100, -10);
        this.fProjectText.setLayoutData((Object)formData2);
        this.fProjectText.addModifyListener(this.fBasicModifyListener);
    }

    private void createRunInLoopComponent(Composite parent) {
        this.fRunInLoop = new Button(parent, 32);
        this.fRunInLoop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VicciMainTab.this.scheduleUpdateJob();
            }
        });
        Label runInLoopLabel = new Label(parent, 0x1000000);
        runInLoopLabel.setText("Run in Loop");
        FormData formData1 = new FormData();
        formData1.top = new FormAttachment((Control)this.fileTextLabel, 16);
        formData1.left = new FormAttachment(0, 10);
        runInLoopLabel.setLayoutData((Object)formData1);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)runInLoopLabel, 0, 128);
        formData2.left = new FormAttachment((Control)runInLoopLabel, 10);
        formData2.right = new FormAttachment(100, -10);
        this.fRunInLoop.setLayoutData((Object)formData2);
        runInLoopLabel.setToolTipText("Select this, if the Process should run in a Loop (a new instance is started, after this process was executed)");
        this.fRunInLoop.setToolTipText("Select this, if the Process should run in a Loop (a new instance is started, after this process was executed)");
    }
}

