/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.launch;

import eu.vicci.process.adapter.util.AdapterUtil;
import eu.vicci.process.client.core.IProcessEngineClient;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;

public class UploadToEngineConfigurationType
implements ILaunchConfigurationDelegate2 {
    private static final String CLIENT_SUFFIX = "_UploadToEngine";
    public static final String ID = "eu.vicci.process.graphiti.execution.launch.uploadToEngineConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String id;
        IFile file = AdapterUtil.getSourceFile((ILaunchConfiguration)configuration);
        this.checkFile(file);
        IProcessEngineClient client = AdapterUtil.createClient((String)CLIENT_SUFFIX);
        if (!client.connect()) {
            this.throwCantConnect(client);
        }
        if ((id = client.uploadModelFile(file.getFullPath().toString())) == null) {
            this.throwAndCloseClient(client, "model upload / deployment or start instance failed");
        }
        if ((id = client.deployProcess(id)) == null) {
            this.throwAndCloseClient(client, "model upload / deployment or start instance failed");
        }
        client.close();
    }

    private void throwAndCloseClient(IProcessEngineClient client, String text) throws DebugException {
        client.close();
        this.throwDebugException(text);
    }

    private void throwCantConnect(IProcessEngineClient client) throws DebugException {
        client.close();
        this.throwDebugException("Cant connect to process engine " + client.getIp() + ":" + client.getPort());
    }

    private void checkFile(IFile file) throws DebugException {
        if (file == null || !file.exists()) {
            this.throwDebugException("file not found : " + file == null ? "null" : file.getFullPath().toString());
        }
    }

    private void throwDebugException(String text) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.graphiti.execution", text));
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }
}

