/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.launch;

import eu.vicci.process.graphiti.execution.launch.LaunchUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractLaunchShortcut
implements ILaunchShortcut,
ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfgurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfgurations(this.getLaunchableResource(editorpart));
    }

    public IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    return (IResource)element;
                }
                ++n2;
            }
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IEditorInput input = editorpart.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    private void launch(IResource file, String mode) {
        if (file instanceof IFile) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
            try {
                ILaunchConfiguration[] configurations = this.getLaunchConfgurations(file);
                if (configurations.length == 0) {
                    ILaunchConfigurationType type = this.getConfigurationType();
                    ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, file.getName());
                    this.addAttributesToConfiguration(file, configuration);
                    configuration.doSave();
                    configurations = new ILaunchConfiguration[]{configuration};
                }
                configurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected abstract void addAttributesToConfiguration(IResource var1, ILaunchConfigurationWorkingCopy var2);

    private ILaunchConfiguration[] getLaunchConfgurations(IResource resource) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        if (resource == null) {
            return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = this.getConfigurationType();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                try {
                    IFile file = LaunchUtil.getSourceFile(configuration);
                    if (resource.equals((Object)file)) {
                        configurations.add(configuration);
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
    }
}

