/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.interpreter;

import eu.vicci.process.graphiti.execution.launch.LaunchUtil;
import eu.vicci.process.graphiti.execution.launch.VicciMainTab;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.slf4j.Logger;

public class ProcessInterpreterConfig {
    private IFile file;
    private boolean runInLoop;

    public ProcessInterpreterConfig(ILaunchConfiguration configuration) throws CoreException {
        this.file = LaunchUtil.getSourceFile(configuration);
        this.runInLoop = VicciMainTab.getRunInLoopFromConfig(configuration);
    }

    public void checkConfigValues(Logger logger) throws DebugException {
        if (this.file != null && this.file.exists()) {
            return;
        }
        logger.error("config in launcher wrong");
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.graphiti.execution", "The config for executing this process step is wrong. "));
    }

    public IFile getFile() {
        return this.file;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public boolean isRunInLoop() {
        return this.runInLoop;
    }

    public void setRunInLoop(boolean runInLoop) {
        this.runInLoop = runInLoop;
    }
}

