/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.debug.model;

import eu.vicci.process.graphiti.execution.debug.model.ProcessDebugElement;
import eu.vicci.process.graphiti.execution.debug.model.ProcessStackFrame;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class ProcessThread
extends ProcessDebugElement
implements IThread {
    private final String processId;
    private final String name;
    private final String debuggerName;
    private ProcessStackFrame stackFrame;

    public ProcessThread(IDebugTarget target, String processId) {
        this(target, processId, processId);
    }

    public ProcessThread(IDebugTarget target, String processId, String name) {
        super(target);
        this.processId = processId;
        this.name = name;
        this.debuggerName = this.createDebuggerName();
        this.stackFrame = new ProcessStackFrame(target, this);
    }

    public String getModelIdentifier() {
        return null;
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.execution.debug", "stepInto() not supported"));
    }

    public void stepOver() throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.execution.debug", "stepOver() not supported"));
    }

    public void stepReturn() throws DebugException {
        throw new DebugException((IStatus)new Status(4, "eu.vicci.process.execution.debug", "stepReturn() not supported"));
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return new IStackFrame[]{this.stackFrame};
    }

    public boolean hasStackFrames() throws DebugException {
        return this.stackFrame != null;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public ProcessStackFrame getTopStackFrame() {
        return this.stackFrame;
    }

    public String getName() {
        return this.debuggerName;
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    public int hashCode() {
        return this.processId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcessThread)) {
            return false;
        }
        ProcessThread t2 = (ProcessThread)((Object)obj);
        String t2Id = null;
        try {
            t2Id = t2.getVicciProcessId();
        }
        catch (Exception exception) {}
        return this.processId.equals(t2Id);
    }

    public String getVicciProcessId() {
        return this.processId;
    }

    public String getVicciProcessName() {
        return this.name;
    }

    private String createDebuggerName() {
        if (this.processId.equals(this.name)) {
            return this.processId;
        }
        return String.valueOf(this.name) + "  ( " + this.processId + " )";
    }
}

