/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.debug.model;

import eu.vicci.process.graphiti.execution.debug.model.ProcessDebugElement;
import eu.vicci.process.graphiti.execution.debug.model.ProcessThread;
import eu.vicci.process.graphiti.execution.debug.model.variables.AbstractProcessVariable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class ProcessStackFrame
extends ProcessDebugElement
implements IStackFrame {
    private List<AbstractProcessVariable> variables = new ArrayList<AbstractProcessVariable>();
    private ProcessThread thread;

    public ProcessStackFrame(IDebugTarget target, ProcessThread thread) {
        super(target);
        this.thread = thread;
    }

    public String getModelIdentifier() {
        return null;
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().resume();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables.toArray(new IVariable[this.variables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.size() > 0;
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.thread.getName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public void addVariables(List<AbstractProcessVariable> variables) throws DebugException {
        for (AbstractProcessVariable var : variables) {
            this.addVariable(var);
        }
    }

    public synchronized void addVariable(AbstractProcessVariable variable) throws DebugException {
        boolean processed = false;
        for (AbstractProcessVariable var : this.variables) {
            if (!var.getName().equals(variable.getName())) continue;
            var.setValue(variable.getValue());
            var.fireChangeEvent(512);
            processed = true;
            break;
        }
        if (!processed) {
            this.variables.add(variable);
        }
    }
}

