/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.debug.dispatcher;

import eu.vicci.process.graphiti.execution.debug.dispatcher.IEventProcessor;
import eu.vicci.process.graphiti.execution.debug.events.IDebugEvent;
import eu.vicci.process.graphiti.execution.debug.events.IDebuggerEvent;
import eu.vicci.process.graphiti.execution.debug.events.IModelRequest;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EventDispatchJob
extends Job {
    private static final String name = "Process Debugger event dispatcher";
    private final List<IDebugEvent> events = new ArrayList<IDebugEvent>();
    private final IEventProcessor host;
    private final IEventProcessor debugger;
    private boolean isTerminated = false;

    public EventDispatchJob(IEventProcessor host, IEventProcessor debugger) {
        super(name);
        this.host = host;
        this.debugger = debugger;
        this.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IDebugEvent event) {
        Object object = this.events;
        synchronized (object) {
            this.events.add(event);
        }
        object = this;
        synchronized (object) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!this.isTerminated) {
            this.runTillTerminated(monitor);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.isTerminated = true;
        EventDispatchJob eventDispatchJob = this;
        synchronized (eventDispatchJob) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    private void runTillTerminated(IProgressMonitor monitor) {
        if (this.events.isEmpty()) {
            this.waitForEvents();
        }
        if (!monitor.isCanceled()) {
            IDebugEvent event = this.removeFirstEvent();
            if (event != null) {
                this.handleEvent(event);
            }
        } else {
            this.terminate();
        }
    }

    private void handleEvent(IDebugEvent event) {
        if (event == null) {
            return;
        }
        if (event instanceof IDebuggerEvent) {
            this.host.handleEvent(event);
        } else if (event instanceof IModelRequest) {
            this.debugger.handleEvent(event);
        } else {
            throw new RuntimeException("Unknown event detected: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDebugEvent removeFirstEvent() {
        IDebugEvent event = null;
        List<IDebugEvent> list = this.events;
        synchronized (list) {
            if (!this.events.isEmpty()) {
                event = this.events.remove(0);
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvents() {
        EventDispatchJob eventDispatchJob = this;
        synchronized (eventDispatchJob) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

