/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.execution.debug;

import eu.vicci.process.graphiti.execution.debug.IDebugger;
import eu.vicci.process.graphiti.execution.debug.dispatcher.EventDispatchJob;
import eu.vicci.process.graphiti.execution.debug.dispatcher.IEventProcessor;
import eu.vicci.process.graphiti.execution.debug.events.DebuggerStartedEvent;
import eu.vicci.process.graphiti.execution.debug.events.IDebugEvent;
import eu.vicci.process.graphiti.execution.debug.events.ResumedEvent;
import eu.vicci.process.graphiti.execution.debug.events.StateChangedEvent;
import eu.vicci.process.graphiti.execution.debug.events.TerminateEvent;
import eu.vicci.process.graphiti.execution.debug.events.TerminatedEvent;
import eu.vicci.process.graphiti.execution.interpreter.ProcessInterpreter;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;

public class ProcessDebugger
implements IDebugger,
IEventProcessor {
    private EventDispatchJob dispatcher;
    private final ProcessInterpreter interpreter;

    public ProcessDebugger(ProcessInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void loaded() {
        this.fireEvent(new DebuggerStartedEvent());
    }

    @Override
    public void terminated() {
        this.fireEvent(new TerminatedEvent());
    }

    @Override
    public void resumed() {
        this.fireEvent(new ResumedEvent());
    }

    @Override
    public void handleEvent(IDebugEvent event) {
        if (event instanceof TerminateEvent) {
            this.interpreter.terminate();
        }
    }

    public void processStateChanged(IStateChangeMessage message) {
        this.fireEvent(new StateChangedEvent(message));
    }

    public void setEventDispatcher(EventDispatchJob dispatcher) {
        this.dispatcher = dispatcher;
    }

    private void fireEvent(IDebugEvent event) {
        this.dispatcher.addEvent(event);
    }
}

