/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.adapter.view.ui;

import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.graphiti.adapter.view.Activator;
import eu.vicci.process.graphiti.adapter.view.ui.IProcessListView;
import eu.vicci.process.graphiti.adapter.view.ui.ProcessListViewController;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class ProcessListView
extends ViewPart
implements IProcessListView {
    private static final String IMAGE_PATH = "media/";
    private Action connectAction;
    private Action startProcessAction;
    private Action stopProcessAction;
    private Action forceConnectAction;
    private Action showPeersAction;
    private TableViewer lProcesses;
    private TableViewer lInstances;
    private ProcessListViewController controller = new ProcessListViewController(this);
    private IMenuListener processesMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)ProcessListView.this.startProcessAction);
        }
    };
    private IMenuListener instancesMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)ProcessListView.this.stopProcessAction);
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite sash = new Composite(parent, 0);
        sash.setLayout((Layout)new FillLayout());
        sash.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(sash, 256);
        Composite compProcesses = new Composite((Composite)sashForm, 0);
        GridLayout layoutProcess = new GridLayout(1, false);
        compProcesses.setLayout((Layout)layoutProcess);
        Composite compInstances = new Composite((Composite)sashForm, 0);
        GridLayout layoutInstances = new GridLayout(1, false);
        compInstances.setLayout((Layout)layoutInstances);
        Label lblProcesses = new Label(compProcesses, 0);
        lblProcesses.setText("Available Processes");
        GridData dataProcesses = new GridData();
        dataProcesses.horizontalAlignment = 4;
        dataProcesses.grabExcessHorizontalSpace = true;
        lblProcesses.setLayoutData((Object)dataProcesses);
        Label lblInstances = new Label(compInstances, 0);
        lblInstances.setText("Process Instances");
        GridData dataInstances = new GridData();
        dataInstances.horizontalAlignment = 4;
        dataInstances.grabExcessHorizontalSpace = true;
        lblInstances.setLayoutData((Object)dataInstances);
        this.lProcesses = new TableViewer(compProcesses);
        GridData dataLProc = new GridData();
        dataLProc.horizontalAlignment = 4;
        dataLProc.grabExcessHorizontalSpace = true;
        dataLProc.verticalAlignment = 4;
        dataLProc.grabExcessVerticalSpace = true;
        this.lProcesses.getTable().setLayoutData((Object)dataLProc);
        this.lInstances = new TableViewer(compInstances);
        GridData dataLIns = new GridData();
        dataLIns.horizontalAlignment = 4;
        dataLIns.grabExcessHorizontalSpace = true;
        dataLIns.verticalAlignment = 4;
        dataLIns.grabExcessVerticalSpace = true;
        this.lInstances.getTable().setLayoutData((Object)dataLIns);
        this.createListColumns();
        this.createClickListeners();
        this.createActions();
        this.createMenu();
        this.createToolBar();
        this.createContextMenu(this.processesMenuListener, this.lProcesses);
        this.createContextMenu(this.instancesMenuListener, this.lInstances);
        this.initListData();
        this.setHeaderVisibility(true);
        this.setListsEnabled(false);
        new Thread(() -> this.controller.viewLoaded()).start();
    }

    public void dispose() {
        super.dispose();
        this.controller.viewDisposed();
    }

    private void createClickListeners() {
        this.lProcesses.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            IProcessInfo pi = (IProcessInfo)selection.getFirstElement();
            this.controller.showProcessInModelEditor(pi);
        });
        this.lInstances.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            IProcessInstanceInfo pi = (IProcessInstanceInfo)selection.getFirstElement();
            this.controller.showProcessInExecutionEditor(pi);
        });
    }

    @Override
    public void clientIsConnected(final boolean connected) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String pic = connected ? "connect-ok-16.png" : "connect-error-16.png";
                ProcessListView.this.forceConnectAction.setImageDescriptor(ProcessListView.this.getImageDescriptor(pic));
                ProcessListView.this.setListsEnabled(connected);
            }
        });
    }

    private void initListData() {
        this.lProcesses.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lProcesses.setInput(this.controller.getProcessInfos());
        this.lInstances.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lInstances.setInput(this.controller.getInstanceInfos());
    }

    private void createListColumns() {
        TableViewerColumn lProcessC1 = new TableViewerColumn(this.lProcesses, 0);
        lProcessC1.getColumn().setWidth(200);
        lProcessC1.getColumn().setText("Process");
        lProcessC1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IProcessInfo)element).getProcessName();
            }
        });
        TableViewerColumn lInstancesC1 = new TableViewerColumn(this.lInstances, 0);
        lInstancesC1.getColumn().setWidth(200);
        lInstancesC1.getColumn().setText("Process Instance");
        lInstancesC1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IProcessInstanceInfo)element).getProcessName();
            }
        });
        TableViewerColumn lInstancesC2 = new TableViewerColumn(this.lInstances, 0);
        lInstancesC2.getColumn().setWidth(120);
        lInstancesC2.getColumn().setText("Instance Number");
        lInstancesC2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Integer.toString(((IProcessInstanceInfo)element).getInstanceNumber());
            }
        });
        TableViewerColumn lInstancesC3 = new TableViewerColumn(this.lInstances, 0);
        lInstancesC3.getColumn().setWidth(200);
        lInstancesC3.getColumn().setText("State");
        lInstancesC3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IProcessInstanceInfo)element).getState().toString();
            }
        });
    }

    public void setFocus() {
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.connectAction);
        mgr.add((IAction)this.showPeersAction);
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.forceConnectAction);
    }

    private void createActions() {
        this.forceConnectAction = new Action(){

            public void run() {
                ProcessListView.this.controller.tryConnect(ProcessListView.this.getSite().getShell());
            }
        };
        this.forceConnectAction.setImageDescriptor(this.getImageDescriptor("connect-error-16.png"));
        this.connectAction = new Action(){

            public void run() {
                ProcessListView.this.controller.showConnectWizard(ProcessListView.this.getSite().getShell());
            }
        };
        this.connectAction.setText("Connect...");
        this.connectAction.setImageDescriptor(this.getImageDescriptor("vicci-logo-small.png"));
        this.startProcessAction = new Action(){

            public void run() {
                ProcessListView.this.startProcessFromProcessList();
            }
        };
        this.startProcessAction.setText("Start");
        this.startProcessAction.setImageDescriptor(this.getImageDescriptor("start-process-small.png"));
        this.stopProcessAction = new Action(){

            public void run() {
                String reason = "Cant stop the Process. Not implemented yet.";
                Status status = new Status(4, "eu.vicci.process.graphiti.adapter.view", reason);
                ErrorDialog.openError((Shell)ProcessListView.this.getViewShell(), (String)"Error", (String)reason, (IStatus)status);
            }
        };
        this.stopProcessAction.setText("Stop");
        this.stopProcessAction.setImageDescriptor(this.getImageDescriptor("stop-process-small.png"));
        this.showPeersAction = new Action(){

            public void run() {
                ProcessListView.this.controller.showPeers();
            }
        };
        this.showPeersAction.setText("Show Peers...");
        this.connectAction.setImageDescriptor(this.getImageDescriptor("vicci-logo-small.png"));
    }

    public void setListsEnabled(boolean enabled) {
        this.lProcesses.getTable().setEnabled(enabled);
        this.lInstances.getTable().setEnabled(enabled);
    }

    private void createContextMenu(IMenuListener listener, TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(listener);
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTable());
        viewer.getTable().setMenu(menu);
    }

    private void setHeaderVisibility(boolean visible) {
        this.lProcesses.getTable().setHeaderVisible(visible);
        this.lInstances.getTable().setHeaderVisible(visible);
    }

    private void startProcessFromProcessList() {
        IStructuredSelection selection = (IStructuredSelection)this.lProcesses.getSelection();
        IProcessInfo pi = (IProcessInfo)selection.getFirstElement();
        if (pi == null) {
            return;
        }
        this.controller.startProcess(pi.getProcessId());
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        return Activator.imageDescriptorFromPlugin((String)"eu.vicci.process.graphiti.adapter.view", (String)(IMAGE_PATH + relativePath));
    }

    @Override
    public void refreshLists() {
        this.refreshLists(true);
    }

    @Override
    public void refreshLists(boolean updateLabels) {
        this.lInstances.getTable().getDisplay().asyncExec(() -> {
            this.lInstances.refresh(updateLabels);
            this.lProcesses.refresh(updateLabels);
        });
    }

    @Override
    public Shell getViewShell() {
        return this.getSite().getShell();
    }
}

