/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.Rectangle;
import eu.vicci.process.gesture.Size;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import java.util.Vector;

public class Utils {
    public static Rectangle FindBox(Vector<Point> points) {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Point p : points) {
            if (p.X < minX) {
                minX = p.X;
            }
            if (p.X > maxX) {
                maxX = p.X;
            }
            if (p.Y < minY) {
                minY = p.Y;
            }
            if (!(p.Y > maxY)) continue;
            maxY = p.Y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public static double round(double x, int digits) {
        return (double)Math.round(x * 10.0 * (double)digits) / (double)(10 * digits);
    }

    public static double Distance(Point p1, Point p2) {
        double dx = p2.X - p1.X;
        double dy = p2.Y - p1.Y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static Point Centroid(Vector<Point> points) {
        double xsum = 0.0;
        double ysum = 0.0;
        for (Point p : points) {
            xsum += p.X;
            ysum += p.Y;
        }
        return new Point(xsum / (double)points.size(), ysum / (double)points.size());
    }

    public static double PathLength(Vector<Point> points) {
        double length = 0.0;
        int i = 1;
        while (i < points.size()) {
            length += Utils.Distance(points.elementAt(i - 1), points.elementAt(i));
            ++i;
        }
        return length;
    }

    public static double AngleInDegrees(Point start, Point end, boolean positiveOnly) {
        double radians = Utils.AngleInRadians(start, end, positiveOnly);
        return Utils.Rad2Deg(radians);
    }

    public static double AngleInRadians(Point start, Point end, boolean positiveOnly) {
        double radians = 0.0;
        if (start.X != end.X) {
            radians = Math.atan2(end.Y - start.Y, end.X - start.X);
        } else if (end.Y < start.Y) {
            radians = -1.5707963267948966;
        } else if (end.Y > start.Y) {
            radians = 1.5707963267948966;
        }
        if (positiveOnly && radians < 0.0) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static double Rad2Deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static double Deg2Rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static Vector<Point> RotateByDegrees(Vector<Point> points, double degrees) {
        double radians = Utils.Deg2Rad(degrees);
        return Utils.RotateByRadians(points, radians);
    }

    public static Vector<Point> RotateByRadians(Vector<Point> points, double radians) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Point c = Utils.Centroid(points);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double cx = c.X;
        double cy = c.Y;
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            double dx = p.X - cx;
            double dy = p.Y - cy;
            Point q = new Point();
            q.X = dx * cos - dy * sin + cx;
            q.Y = dx * sin + dy * cos + cy;
            newPoints.add(q);
            ++i;
        }
        return newPoints;
    }

    public static Point RotatePoint(Point p, Point c, double radians) {
        Point q = new Point();
        q.X = (p.X - c.X) * Math.cos(radians) - (p.Y - c.Y) * Math.sin(radians) + c.X;
        q.Y = (p.X - c.X) * Math.sin(radians) + (p.Y - c.Y) * Math.cos(radians) + c.Y;
        return q;
    }

    public static Point CalcStartUnitVector(Vector<Point> points, int index) {
        Point v = new Point(points.elementAt((int)index).X - points.elementAt((int)0).X, points.elementAt((int)index).Y - points.elementAt((int)0).Y);
        double len = Math.sqrt(v.X * v.X + v.Y * v.Y);
        return new Point(v.X / len, v.Y / len);
    }

    public static double AngleBetweenUnitVectors(Point v1, Point v2) {
        double test = v1.X * v2.X + v1.Y * v2.Y;
        if (test < -1.0) {
            test = -1.0;
        }
        if (test > 1.0) {
            test = 1.0;
        }
        return Math.acos(test);
    }

    public static Vector<Point> TranslateBBoxTo(Vector<Point> points, Point toPt) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Rectangle r = Utils.FindBox(points);
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            p.X += toPt.X - r.getX();
            p.Y += toPt.Y - r.getY();
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> TranslateCentroidTo(Vector<Point> points, Point toPt) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Point centroid = Utils.Centroid(points);
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            p.X += toPt.X - centroid.X;
            p.Y += toPt.Y - centroid.Y;
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> TranslateBy(Vector<Point> points, Size sz) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            p.X += sz.getWidth();
            p.Y += sz.getHeight();
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> Scale(Vector<Point> pts, double oneDRatio, Size size) {
        if (NDollarParameters.getInstance().UseUniformScaling) {
            Point centroid = Utils.Centroid(pts);
            double radiusSquared = 1.0;
            for (Point point : pts) {
                double distanceSquared = Math.pow(centroid.X - point.X, 2.0) + Math.pow(centroid.Y - point.Y, 2.0);
                if (!(distanceSquared > radiusSquared)) continue;
                radiusSquared = distanceSquared;
            }
            double factor = size.getWidth() / Math.sqrt(radiusSquared);
            Vector<Point> scaledPts = new Vector<Point>();
            int i = 0;
            while (i < pts.size()) {
                Point p = new Point(pts.elementAt(i));
                p.X *= factor;
                p.Y *= factor;
                scaledPts.add(p);
                ++i;
            }
            return scaledPts;
        }
        return Utils.ScaleByDimension(pts, oneDRatio, size);
    }

    public static Vector<Point> ScaleByDimension(Vector<Point> points, double oneDRatio, Size size) {
        Rectangle B = Utils.FindBox(points);
        boolean uniformly = false;
        if (NDollarParameters.getInstance().TestFor1D) {
            uniformly = Math.min(B.getWidth() / B.getHeight(), B.getHeight() / B.getWidth()) <= oneDRatio;
        }
        Vector<Point> newpoints = new Vector<Point>(points.size());
        int i = 0;
        while (i < points.size()) {
            double qx = uniformly ? points.elementAt((int)i).X * (size.getWidth() / Math.max(B.getWidth(), B.getHeight())) : points.elementAt((int)i).X * (size.getWidth() / B.getWidth());
            double qy = uniformly ? points.elementAt((int)i).Y * (size.getHeight() / Math.max(B.getWidth(), B.getHeight())) : points.elementAt((int)i).Y * (size.getHeight() / B.getHeight());
            newpoints.add(new Point(qx, qy));
            ++i;
        }
        return newpoints;
    }

    public static Vector<Point> ScaleTo(Vector<Point> points, Size sz) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Rectangle r = Utils.FindBox(points);
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            if (r.getWidth() != 0.0) {
                p.X *= sz.getWidth() / r.getWidth();
            }
            if (r.getHeight() != 0.0) {
                p.Y *= sz.getHeight() / r.getHeight();
            }
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> ScaleTo1D(Vector<Point> points, Size sz) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Rectangle r = Utils.FindBox(points);
        double scaleFactor = 0.0;
        scaleFactor = r.getWidth() > r.getHeight() ? r.getWidth() : r.getHeight();
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            if (r.getWidth() != 0.0) {
                p.X *= sz.getWidth() / scaleFactor;
            }
            if (r.getHeight() != 0.0) {
                p.Y *= sz.getHeight() / scaleFactor;
            }
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> ScaleBy(Vector<Point> points, Size sz) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            p.X *= sz.getWidth();
            p.Y *= sz.getHeight();
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> ScaleToMax(Vector<Point> points, Rectangle box) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Rectangle r = Utils.FindBox(points);
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            p.X *= box.getMaxSide() / r.getMaxSide();
            p.Y *= box.getMaxSide() / r.getMaxSide();
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> ScaleToMin(Vector<Point> points, Rectangle box) {
        Vector<Point> newPoints = new Vector<Point>(points.size());
        Rectangle r = Utils.FindBox(points);
        int i = 0;
        while (i < points.size()) {
            Point p = points.elementAt(i);
            p.X *= box.getMinSide() / r.getMinSide();
            p.Y *= box.getMinSide() / r.getMinSide();
            newPoints.add(p);
            ++i;
        }
        return newPoints;
    }

    public static Vector<Point> Resample(Vector<Point> points, int n) {
        double I = Utils.PathLength(points) / (double)(n - 1);
        double D = 0.0;
        Vector<Point> srcPts = new Vector<Point>(points);
        Vector<Point> dstPts = new Vector<Point>(n);
        dstPts.add(srcPts.elementAt(0));
        int i = 1;
        while (i < srcPts.size()) {
            Point pt2;
            Point pt1 = srcPts.elementAt(i - 1);
            double d = Utils.Distance(pt1, pt2 = srcPts.elementAt(i));
            if (D + d >= I) {
                double qx = pt1.X + (I - D) / d * (pt2.X - pt1.X);
                double qy = pt1.Y + (I - D) / d * (pt2.Y - pt1.Y);
                Point q = new Point(qx, qy);
                dstPts.add(q);
                srcPts.insertElementAt(q, i);
                D = 0.0;
            } else {
                D += d;
            }
            ++i;
        }
        if (dstPts.size() == n - 1) {
            dstPts.add(srcPts.elementAt(srcPts.size() - 1));
        }
        return dstPts;
    }

    public static double PathDistance(Vector<Point> path1, Vector<Point> path2) {
        double distance = 0.0;
        int i = 0;
        while (i < path1.size()) {
            distance += Utils.Distance(path1.elementAt(i), path2.elementAt(i));
            ++i;
        }
        return distance / (double)path1.size();
    }

    public static int Random(int low, int high) {
        return low + (int)(((double)high - (double)low) * Math.random());
    }

    public static int[] Random(int low, int high, int num) {
        int[] array = new int[num];
        int i = 0;
        while (i < num) {
            array[i] = Utils.Random(low, high + 1);
            int j = 0;
            while (j < i) {
                if (array[i] == array[j]) {
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static boolean Is1DGesture(Vector<Point> rawPts) {
        Vector<Point> pts = new Vector<Point>(rawPts);
        double radians = Utils.AngleInRadians(Utils.Centroid(pts), pts.elementAt(0), false);
        Rectangle r = Utils.FindBox(pts = Utils.RotateByRadians(pts, -radians));
        if (r.getWidth() == 0.0 || r.getHeight() == 0.0) {
            return true;
        }
        if (r.getWidth() / r.getHeight() < r.getHeight() / r.getWidth()) {
            return r.getWidth() / r.getHeight() < 0.3;
        }
        return r.getHeight() / r.getWidth() < 0.3;
    }
}

