/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.recognizer.ndollar.Category;
import eu.vicci.process.gesture.recognizer.ndollar.Multistroke;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SamplesCollection
extends Hashtable<String, Dictionary<String, Category>> {
    private static final long serialVersionUID = 1L;

    public Enumeration<String> getUsers() {
        return this.keys();
    }

    public Vector<String> GetUsersVector() {
        Vector<String> allUsers = new Vector<String>(this.size());
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String u = (String)keys.nextElement();
            allUsers.add(u);
        }
        return allUsers;
    }

    public boolean ContainsUser(String user) {
        return this.get(user) != null;
    }

    public Category GetCategoryByUser(String user, String catName) {
        if (this.get(user) == null) {
            return null;
        }
        if (((Dictionary)this.get(user)).get(catName) == null) {
            return null;
        }
        return (Category)((Dictionary)this.get(user)).get(catName);
    }

    public boolean RemoveSamples(String user, String catName) {
        if (this.get(user) == null) {
            return false;
        }
        if (((Dictionary)this.get(user)).get(catName) == null) {
            return false;
        }
        ((Dictionary)this.get(user)).remove(catName);
        return true;
    }

    public void AddExample(Multistroke p) {
        String catName = Category.ParseName(p.Name);
        if (this.get(p.User) != null) {
            if (((Dictionary)this.get(p.User)).get(catName) != null) {
                Dictionary forUser = (Dictionary)this.get(p.User);
                Category cat = (Category)forUser.get(catName);
                cat.AddExample(p);
            } else {
                Dictionary forUser = (Dictionary)this.get(p.User);
                forUser.put(catName, new Category(catName, p));
            }
        } else {
            Hashtable<String, Category> forUser = new Hashtable<String, Category>();
            ((Dictionary)forUser).put(catName, new Category(catName, p));
            this.put(p.User, forUser);
        }
    }

    public int GetMinNumExamplesForUser(String user) {
        int minNumExamples = 9999;
        if (this.containsKey(user)) {
            Dictionary allCats = (Dictionary)this.get(user);
            Enumeration en = allCats.elements();
            while (en.hasMoreElements()) {
                Category c = (Category)en.nextElement();
                if (c.getNumExamples() >= minNumExamples) continue;
                minNumExamples = c.getNumExamples();
            }
        }
        return minNumExamples;
    }

    public boolean AreNumExamplesEqualForUser(String user) {
        if (this.containsKey(user)) {
            Dictionary allCats = (Dictionary)this.get(user);
            Enumeration en = allCats.elements();
            int prevNumExamples = -1;
            while (en.hasMoreElements()) {
                Category c = (Category)en.nextElement();
                if (prevNumExamples == -1) {
                    prevNumExamples = c.getNumExamples();
                }
                if (c.getNumExamples() == prevNumExamples) continue;
                return false;
            }
        }
        return true;
    }

    public int MaxNumCategories() {
        return this.GetCategoriesVector().size();
    }

    public int NumCategoriesForUser(String user) {
        return ((Dictionary)this.get(user)).size();
    }

    public Vector<Category> GetCategoriesVector() {
        Vector<Category> allCats = new Vector<Category>();
        Enumeration users = this.keys();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            Enumeration cats = ((Dictionary)this.get(user)).elements();
            while (cats.hasMoreElements()) {
                Category category = (Category)cats.nextElement();
                if (allCats.contains(category)) continue;
                allCats.add(category);
            }
        }
        return allCats;
    }

    public Vector<Category> GetCategories(String user) {
        Vector<Category> allCats = new Vector<Category>();
        Enumeration cats = ((Dictionary)this.get(user)).elements();
        while (cats.hasMoreElements()) {
            Category category = (Category)cats.nextElement();
            if (allCats.contains(category)) continue;
            allCats.add(category);
        }
        return allCats;
    }
}

