/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.Size;
import eu.vicci.process.gesture.recognizer.ndollar.Category;
import eu.vicci.process.gesture.recognizer.ndollar.Gesture;
import eu.vicci.process.gesture.recognizer.ndollar.Multistroke;
import eu.vicci.process.gesture.recognizer.ndollar.NBestList;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import eu.vicci.process.gesture.recognizer.ndollar.SamplesCollection;
import eu.vicci.process.gesture.recognizer.ndollar.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class NDollarRecognizer {
    private static final String NAMESPACE = null;
    private static final String VERSION = "1.0";
    private static final double DX = 250.0;
    public static final Size ResampleScale = new Size(250.0, 250.0);
    public static final double Diagonal = Math.sqrt(125000.0);
    public static final double HalfDiagonal = 0.5 * Diagonal;
    public static final Point ResampleOrigin = new Point(0.0, 0.0);
    private static final double Phi = 0.5 * (-1.0 + Math.sqrt(5.0));
    private static final double _RotationBound = 45.0;
    public static final double _1DThreshold = 0.3;
    private static final int _MinExamples = 5;
    private static final int NumRandomTests = 100;
    private Hashtable<String, Multistroke> _gestures = new Hashtable(256);
    public static final boolean _debug = false;
    static int cnt = 0;

    public Hashtable<String, Multistroke> getGestures() {
        return this._gestures;
    }

    public NBestList Recognize(Vector<Point> points, int numStrokes) {
        Gesture candidate = new Gesture(points);
        NBestList nbest = new NBestList();
        int totalComparisons = 0;
        int actualComparisons = 0;
        for (Multistroke ms : this._gestures.values()) {
            if (NDollarParameters.getInstance().MatchOnlyIfSameNumberOfStrokes && numStrokes != ms.NumStrokes) continue;
            NBestList thisMSnbest = new NBestList();
            for (Gesture p : ms.Gestures) {
                ++totalComparisons;
                if (NDollarParameters.getInstance().DoStartAngleComparison && (!NDollarParameters.getInstance().DoStartAngleComparison || !(Utils.AngleBetweenUnitVectors(candidate.StartUnitVector, p.StartUnitVector) <= NDollarParameters.getInstance().StartAngleThreshold))) continue;
                ++actualComparisons;
                double score = -1.0;
                double[] best = new double[]{-1.0, -1.0, -1.0};
                if (NDollarParameters.getInstance().SearchMethod == NDollarParameters.PossibleSearchMethods.GSS) {
                    best = this.GoldenSectionSearch(candidate.Points, p.Points, Utils.Deg2Rad(-45.0), Utils.Deg2Rad(45.0), Utils.Deg2Rad(2.0));
                    score = 1.0 - best[0] / HalfDiagonal;
                } else if (NDollarParameters.getInstance().SearchMethod == NDollarParameters.PossibleSearchMethods.Protractor) {
                    best = this.OptimalCosineDistance(p.VectorVersion, candidate.VectorVersion);
                    score = 1.0 / best[0];
                }
                thisMSnbest.AddResult(p.Name, score, best[0], best[1]);
            }
            thisMSnbest.SortDescending();
            nbest.AddResult(thisMSnbest.getName(), thisMSnbest.getScore(), thisMSnbest.getDistance(), thisMSnbest.getAngle());
        }
        nbest.SortDescending();
        nbest.setTotalComparisons(totalComparisons);
        nbest.setActualComparisons(actualComparisons);
        return nbest;
    }

    private double[] OptimalCosineDistance(Vector<Double> v1, Vector<Double> v2) {
        double a = 0.0;
        double b = 0.0;
        int i = 0;
        while (i < v1.size()) {
            a = a + v1.elementAt(i) * v2.elementAt(i) + v1.elementAt(i + 1) * v2.elementAt(i + 1);
            b = b + v1.elementAt(i) * v2.elementAt(i + 1) - v1.elementAt(i + 1) * v2.elementAt(i);
            i += 2;
        }
        double angle = Math.atan(b / a);
        return new double[]{Math.acos(a * Math.cos(angle) + b * Math.sin(angle)), Utils.Rad2Deg(angle), 0.0};
    }

    private double[] GoldenSectionSearch(Vector<Point> pts1, Vector<Point> pts2, double a, double b, double threshold) {
        double x1 = Phi * a + (1.0 - Phi) * b;
        Vector<Point> newPoints = Utils.RotateByRadians(pts1, x1);
        double fx1 = Utils.PathDistance(newPoints, pts2);
        double x2 = (1.0 - Phi) * a + Phi * b;
        newPoints = Utils.RotateByRadians(pts1, x2);
        double fx2 = Utils.PathDistance(newPoints, pts2);
        double i = 2.0;
        while (Math.abs(b - a) > threshold) {
            if (fx1 < fx2) {
                b = x2;
                x2 = x1;
                fx2 = fx1;
                x1 = Phi * a + (1.0 - Phi) * b;
                newPoints = Utils.RotateByRadians(pts1, x1);
                fx1 = Utils.PathDistance(newPoints, pts2);
            } else {
                a = x1;
                x1 = x2;
                fx1 = fx2;
                x2 = (1.0 - Phi) * a + Phi * b;
                newPoints = Utils.RotateByRadians(pts1, x2);
                fx2 = Utils.PathDistance(newPoints, pts2);
            }
            i += 1.0;
        }
        return new double[]{Math.min(fx1, fx2), Utils.Rad2Deg((b + a) / 2.0), i};
    }

    private double[] HillClimbSearch(Vector<Point> pts1, Vector<Point> pts2, double D, double step) {
        double i = 0.0;
        double theta = 0.0;
        double d = D;
        do {
            D = d;
            Vector<Point> newPoints = Utils.RotateByDegrees(pts1, theta += step);
            d = Utils.PathDistance(newPoints, pts2);
            i += 1.0;
        } while (d <= D);
        return new double[]{D, theta - step, i};
    }

    private double[] FullSearch(Vector<Point> pts1, Vector<Point> pts2, OutputStreamWriter writer) {
        double bestA = 0.0;
        double bestD = Utils.PathDistance(pts1, pts2);
        try {
            int i = -180;
            while (i <= 180) {
                Vector<Point> newPoints = Utils.RotateByDegrees(pts1, i);
                double d = Utils.PathDistance(newPoints, pts2);
                if (writer != null) {
                    writer.write(MessageFormat.format("{0}\t{1,number}", i, Utils.round(d, 3)));
                }
                if (d < bestD) {
                    bestD = d;
                    bestA = i;
                }
                ++i;
            }
            writer.write(MessageFormat.format("\nFull Search (360 rotations)\n{0,number}{1}\t{2,number} px", Utils.round(bestA, 2), Character.valueOf('\u00b0'), Utils.round(bestD, 3)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new double[]{bestD, bestA, 360.0};
    }

    public boolean SaveGesture(String filename, Vector<Vector<Point>> strokes, Vector<Integer> numPtsInStroke) {
        String name = Gesture.ParseName(filename);
        Multistroke newPrototype = new Multistroke(name, "test", "test", strokes);
        if (this._gestures.containsKey(name)) {
            newPrototype.Name = String.valueOf(newPrototype.Name) + "-" + ++cnt;
        }
        this._gestures.put(newPrototype.Name, newPrototype);
        Vector<Point> points = newPrototype.OriginalGesture.RawPoints;
        Point p0 = points.elementAt(0);
        Point pn = points.elementAt(points.size() - 1);
        boolean success = true;
        boolean indentation = true;
        XmlSerializer writer = null;
        OutputStreamWriter osw = null;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            writer = factory.newSerializer();
            osw = new OutputStreamWriter(new FileOutputStream(filename));
            writer.setOutput((Writer)osw);
            writer.startTag(NAMESPACE, "Gesture");
            writer.attribute(NAMESPACE, "Name", name);
            writer.attribute(NAMESPACE, "Subject", "test");
            writer.attribute(NAMESPACE, "Speed", "test");
            writer.attribute(NAMESPACE, "NumPts", Integer.toString(points.size()));
            writer.attribute(NAMESPACE, "Milliseconds", Integer.toString(pn.T - p0.T));
            writer.attribute(NAMESPACE, "AppName", String.valueOf(this.getClass().getName()) + "-java");
            writer.attribute(NAMESPACE, "AppVer", VERSION);
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            writer.attribute(NAMESPACE, "Date", dateFormat.format(GregorianCalendar.getInstance().getTime()));
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            writer.attribute(NAMESPACE, "TimeOfDay", timeFormat.format(GregorianCalendar.getInstance().getTime()));
            if (indentation) {
                writer.text("\n");
            }
            int numStrokesWritten = 0;
            for (Vector<Point> pts : strokes) {
                writer.startTag(NAMESPACE, "Stroke");
                writer.attribute(NAMESPACE, "index", Integer.toString(numStrokesWritten + 1));
                if (indentation) {
                    writer.text("\n");
                }
                ++numStrokesWritten;
                for (Point p : pts) {
                    writer.startTag(NAMESPACE, "Point");
                    writer.attribute(NAMESPACE, "X", Double.toString(p.X));
                    writer.attribute(NAMESPACE, "Y", Double.toString(p.Y));
                    writer.attribute(NAMESPACE, "T", Integer.toString(p.T));
                    writer.endTag(NAMESPACE, "Point");
                    if (!indentation) continue;
                    writer.text("\n");
                }
                writer.endTag(NAMESPACE, "Stroke");
                if (!indentation) continue;
                writer.text("\n");
            }
            writer.endTag(NAMESPACE, "Gesture");
            if (indentation) {
                writer.text("\n");
            }
            writer.endDocument();
            writer.flush();
            if (osw != null) {
                osw.close();
            }
        }
        catch (IOException xex) {
            xex.printStackTrace();
            success = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }

    public boolean LoadGesture(String filename) {
        return this.LoadGesture(new File(filename));
    }

    public boolean LoadGesture(File file) {
        boolean success = true;
        MXParser reader = null;
        FileInputStream fis = null;
        try {
            reader = new MXParser();
            fis = new FileInputStream(file);
            reader.setInput((InputStream)fis, "UTF-8");
            this.AddGestureFromXML(reader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }

    public boolean AddGestureFromXML(MXParser reader) {
        boolean success = true;
        try {
            Multistroke p = this.ReadGesture((XmlPullParser)reader);
            if (this._gestures.containsKey(p.Name)) {
                p.Name = String.valueOf(p.Name) + "-" + ++cnt;
            }
            System.out.println("add " + p.Name);
            this._gestures.put(p.Name, p);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }

    private Multistroke ReadGesture(XmlPullParser reader) {
        String name = "";
        String user = "";
        String speed = "";
        Vector<Point> points = new Vector<Point>();
        Vector<Vector<Point>> strokes = new Vector<Vector<Point>>();
        try {
            int next = reader.next();
            while (next != 1) {
                if (next == 2 && reader.getName().equals("Gesture")) {
                    int i = 0;
                    while (i < reader.getAttributeCount()) {
                        if (reader.getAttributeName(i).equals("Name")) {
                            name = reader.getAttributeValue(i);
                        } else if (reader.getAttributeName(i).equals("Subject")) {
                            user = reader.getAttributeValue(i);
                        } else if (reader.getAttributeName(i).equals("Speed")) {
                            speed = reader.getAttributeValue(i);
                        }
                        ++i;
                    }
                } else if (next == 2 && reader.getName().equals("Point")) {
                    Point p = new Point();
                    int i = 0;
                    while (i < reader.getAttributeCount()) {
                        if (reader.getAttributeName(i).equals("X")) {
                            p.X = Double.parseDouble(reader.getAttributeValue(i));
                        } else if (reader.getAttributeName(i).equals("Y")) {
                            p.Y = Double.parseDouble(reader.getAttributeValue(i));
                        } else if (reader.getAttributeName(i).equals("T")) {
                            p.T = Integer.parseInt(reader.getAttributeValue(i));
                        }
                        ++i;
                    }
                    points.add(p);
                } else if (next == 2 && reader.getName().equals("Stroke")) {
                    strokes.add(new Vector(points));
                    points = new Vector();
                }
                next = reader.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        strokes.add(new Vector(points));
        return new Multistroke(name, user, speed, strokes);
    }

    public SamplesCollection AssembleBatch(File[] files, boolean include1D, boolean include2D) {
        SamplesCollection categoriesByUser = new SamplesCollection();
        System.out.println("Assembling batch from files");
        int i = 0;
        while (i < files.length) {
            FileInputStream fis = null;
            MXParser reader = null;
            try {
                fis = new FileInputStream(files[i]);
                reader = new MXParser();
                reader.setInput((InputStream)fis, "UTF-8");
                Multistroke p = this.ReadGesture((XmlPullParser)reader);
                if (p.OriginalGesture.Is1D && include1D) {
                    categoriesByUser.AddExample(p);
                } else if (!p.OriginalGesture.Is1D && include2D) {
                    categoriesByUser.AddExample(p);
                }
                System.out.print(".");
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                categoriesByUser = null;
            }
            ++i;
        }
        System.out.println();
        Enumeration users = categoriesByUser.keys();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            if (!categoriesByUser.AreNumExamplesEqualForUser(user)) {
                System.out.println("Warning: in case you were not expecting it, there is a different number of samples across categories for user " + user + ".");
            }
            Vector<String> catsToRemove = new Vector<String>();
            Enumeration cats = ((Dictionary)categoriesByUser.get(user)).keys();
            while (cats.hasMoreElements()) {
                String cat = (String)cats.nextElement();
                if (categoriesByUser.GetCategoryByUser(user, cat).getNumExamples() >= 5) continue;
                catsToRemove.add(cat);
            }
            for (String s : catsToRemove) {
                categoriesByUser.RemoveSamples(user, s);
            }
        }
        System.out.println("Done assembling batch.");
        return categoriesByUser;
    }

    public boolean TestBatch(SamplesCollection categoriesByUser, String dir) {
        System.out.println("Testing batch (one tick per user)");
        boolean success = true;
        OutputStreamWriter mainWriter = null;
        OutputStreamWriter recWriter = null;
        try {
            long start = System.currentTimeMillis();
            String mainFile = MessageFormat.format("{0}\\ndollar_main_{1}.csv", dir, start);
            String recFile = MessageFormat.format("{0}\\ndollar_data_{1}.csv", dir, start);
            mainWriter = new OutputStreamWriter(new FileOutputStream(new File(mainFile)));
            mainWriter.write(MessageFormat.format("Recognizer:,ndollar, StartTime(ms):,{0}\n", start));
            mainWriter.write(MessageFormat.format("Testing:,within-user,Matching method:,{0},Rotation invariance:,{1},Rotation bound:,{2},1D Threshold:,{3},Do start angle comparison:,{4},Start angle index:,{5},Start angle threshold:,{6},Do match only same number of strokes:,{7},Test for 1D gestures:,{8},UseUniformScaling:,{9}\n", NDollarParameters.getInstance().SearchMethod == NDollarParameters.PossibleSearchMethods.GSS ? "GSS" : "Protractor", NDollarParameters.getInstance().RotationInvariant, 45.0, 0.3, NDollarParameters.getInstance().DoStartAngleComparison, NDollarParameters.getInstance().StartAngleIndex, Utils.Rad2Deg(NDollarParameters.getInstance().StartAngleThreshold), NDollarParameters.getInstance().MatchOnlyIfSameNumberOfStrokes, NDollarParameters.getInstance().TestFor1D, NDollarParameters.getInstance().UseUniformScaling));
            mainWriter.write("Recognizer,Subject,Speed,NumTraining,GestureType,RecognitionRate");
            recWriter = new OutputStreamWriter(new FileOutputStream(new File(recFile)));
            recWriter.write(MessageFormat.format("Recognizer:,ndollar, StartTime(ms):,{0}\n", start));
            recWriter.write(MessageFormat.format("Testing:,within-user,Matching method:,{0},Rotation invariance:,{1},Rotation bound:,{2},1D Threshold:,{3},Do start angle comparison:,{4},Start angle index:,{5},Start angle threshold:,{6},Do match only same number of strokes:,{7},Test for 1D gestures:,{8},UseUniformScaling:,{9}\n", NDollarParameters.getInstance().SearchMethod == NDollarParameters.PossibleSearchMethods.GSS ? "GSS" : "Protractor", NDollarParameters.getInstance().RotationInvariant, 45.0, 0.3, NDollarParameters.getInstance().DoStartAngleComparison, NDollarParameters.getInstance().StartAngleIndex, Utils.Rad2Deg(NDollarParameters.getInstance().StartAngleThreshold), NDollarParameters.getInstance().MatchOnlyIfSameNumberOfStrokes, NDollarParameters.getInstance().TestFor1D, NDollarParameters.getInstance().UseUniformScaling));
            recWriter.write("Subject,Speed,Correct?,NumTrain,Tested,Character,ActualComparisons,TotalComparisons,Is1D,1stCorrect,Pts,Ms,NumStrokes,Angle,:,(NBestNames),[NBestScores]");
            Enumeration users = categoriesByUser.keys();
            while (users.hasMoreElements()) {
                String user = (String)users.nextElement();
                System.out.print(".");
                String speed = "unknown";
                int minNumExamples = categoriesByUser.GetMinNumExamplesForUser(user);
                int n = 1;
                while (n <= minNumExamples - 1) {
                    Hashtable<String, Double> results = new Hashtable<String, Double>();
                    int r = 0;
                    while (r < 100) {
                        this._gestures.clear();
                        Enumeration cats = ((Dictionary)categoriesByUser.get(user)).keys();
                        while (cats.hasMoreElements()) {
                            String cat = (String)cats.nextElement();
                            Category c = (Category)((Dictionary)categoriesByUser.get(user)).get(cat);
                            int[] chosen = Utils.Random(0, c.getNumExamples() - 1, n);
                            int j = 0;
                            while (j < chosen.length) {
                                Multistroke p = c.get(chosen[j]);
                                this._gestures.put(p.Name, p);
                                ++j;
                            }
                        }
                        Enumeration cats2 = ((Dictionary)categoriesByUser.get(user)).keys();
                        while (cats2.hasMoreElements()) {
                            String cat = (String)cats2.nextElement();
                            Category c = (Category)((Dictionary)categoriesByUser.get(user)).get(cat);
                            int[] notLoaded = new int[c.getNumExamples() - n];
                            int j = 0;
                            int k = 0;
                            while (j < c.getNumExamples()) {
                                Multistroke g = c.get(j);
                                if (!this._gestures.containsKey(g.Name)) {
                                    notLoaded[k++] = j;
                                }
                                ++j;
                            }
                            int chosen = Utils.Random(0, notLoaded.length - 1);
                            Multistroke ms = c.get(notLoaded[chosen]);
                            Gesture p = ms.OriginalGesture;
                            NBestList result = this.Recognize(p.RawPoints, ms.NumStrokes);
                            String category = Category.ParseName(result.getName());
                            int correct = c.getName().equals(category) ? 1 : 0;
                            recWriter.write(MessageFormat.format("\n{0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13,number}{14},:,({15}),[{16}]", ms.User, ms.Speed, correct, n, p.Name, Category.ParseName(p.Name), result.getActualComparisons(), result.getTotalComparisons(), p.Is1D, this.FirstCorrect(p.Name, result.getNames()), p.RawPoints.size(), p.getDuration(), ms.NumStrokes, Utils.round(result.getAngle(), 1), Character.valueOf('\u00b0'), result.getNamesString(), result.getScoresString()));
                            if (results.containsKey(cat)) {
                                double temp = (Double)results.get(cat) + (double)correct;
                                results.put(cat, temp);
                                continue;
                            }
                            results.put(cat, Double.valueOf(correct));
                        }
                        ++r;
                    }
                    Enumeration cats3 = ((Dictionary)categoriesByUser.get(user)).keys();
                    while (cats3.hasMoreElements()) {
                        String cat = (String)cats3.nextElement();
                        double temp = (Double)results.get(cat) / 100.0;
                        results.put(cat, temp);
                        mainWriter.write(MessageFormat.format("ndollar,{0},{1},{2},{3},{4,number}", user, speed, n, cat, Utils.round((Double)results.get(cat), 3)));
                    }
                    ++n;
                }
            }
            long end = System.currentTimeMillis();
            mainWriter.write(MessageFormat.format("\nEndTime(ms):,{0}, Minutes:,{1,number,integer}", end, Utils.round((double)(end - start) / 60000.0, 2)));
            recWriter.write(MessageFormat.format("\nEndTime(ms):,{0}, Minutes:,{1,number,integer}", end, Utils.round((double)(end - start) / 60000.0, 2)));
            System.out.println();
            System.out.println("Done testing batch.");
            if (mainWriter != null) {
                mainWriter.close();
            }
            if (recWriter != null) {
                recWriter.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }

    private int FirstCorrect(String name, String[] names) {
        String category = Category.ParseName(name);
        int i = 0;
        while (i < names.length) {
            String c = Category.ParseName(names[i]);
            if (category.equals(c)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public boolean CreateRotationGraph(String file1, String file2, String dir, boolean similar) {
        boolean success = true;
        OutputStreamWriter writer = null;
        FileInputStream fis = null;
        MXParser reader = null;
        try {
            fis = new FileInputStream(new File(file1));
            reader = new MXParser();
            reader.setInput((InputStream)fis, "UTF-8");
            Multistroke g1 = this.ReadGesture((XmlPullParser)reader);
            fis.close();
            fis = new FileInputStream(new File(file2));
            reader = new MXParser();
            reader.setInput((InputStream)fis, "UTF-8");
            Multistroke g2 = this.ReadGesture((XmlPullParser)reader);
            fis.close();
            fis = null;
            String outfile = MessageFormat.format("{0}\\{1}({2}, {3})_{4}.txt", dir, similar ? "o" : "x", g1.Name, g2.Name, System.currentTimeMillis());
            FileOutputStream fos = new FileOutputStream(new File(outfile));
            writer = new OutputStreamWriter(fos);
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            writer.write(MessageFormat.format("Rotated: {0} --> {1}. {2}, {3}\n", g1.Name, g2.Name, dateFormat.format(GregorianCalendar.getInstance().getTime()), timeFormat.format(GregorianCalendar.getInstance().getTime())));
            double[] full = this.FullSearch(g1.OriginalGesture.Points, g2.OriginalGesture.Points, writer);
            double init = Utils.PathDistance(g1.OriginalGesture.Points, g2.OriginalGesture.Points);
            double[] pos = this.HillClimbSearch(g1.OriginalGesture.Points, g2.OriginalGesture.Points, init, 1.0);
            double[] neg = this.HillClimbSearch(g1.OriginalGesture.Points, g2.OriginalGesture.Points, init, -1.0);
            double[] best = new double[3];
            best = neg[0] < pos[0] ? neg : pos;
            writer.write(MessageFormat.format("\nHill Climb Search ({0} rotations)\n{1,number}{2}\t{3,number} px", pos[2] + neg[2] + 1.0, Utils.round(best[1], 2), Character.valueOf('\u00b0'), Utils.round(best[0], 3)));
            double[] gold = this.GoldenSectionSearch(g1.OriginalGesture.Points, g2.OriginalGesture.Points, Utils.Deg2Rad(-45.0), Utils.Deg2Rad(45.0), Utils.Deg2Rad(2.0));
            writer.write(MessageFormat.format("\nGolden Section Search ({0} rotations)\n{1,number}{2}\t{3,number} px", gold[2], Utils.round(gold[1], 2), Character.valueOf('\u00b0'), Utils.round(gold[0], 3)));
            writer.write(MessageFormat.format("\n{0} {1} {2,number} {3,number} {4,number} {5,number} {6} {7,number} {8,number} {9,number} {10} {11,number} {12,number} {13,number} {14}", g1.Name, g2.Name, Math.abs(Utils.round(full[1], 2)), Utils.round(full[1], 2), Utils.round(full[0], 3), Utils.round(init, 3), full[2], Math.abs(Utils.round(best[1], 2)), Utils.round(best[1], 2), Utils.round(best[0], 3), pos[2] + neg[2] + 1.0, Math.abs(Utils.round(gold[1], 2)), Utils.round(gold[1], 2), Utils.round(gold[0], 3), gold[2]));
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }
}

