/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.recognizer.ndollar.Utils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;

public class NBestList {
    public static NBestList Empty = new NBestList();
    private ArrayList<NBestResult> _nBestList = new ArrayList();
    private int _totalComparisons = 0;
    private int _actualComparisons = 0;

    public boolean getIsEmpty() {
        return this._nBestList.size() == 0;
    }

    public void AddResult(String name, double score, double distance, double angle) {
        NBestResult r = new NBestResult(name, score, distance, angle);
        this._nBestList.add(r);
    }

    public void SortDescending() {
        Collections.sort(this._nBestList);
    }

    public int getTotalComparisons() {
        return this._totalComparisons;
    }

    public void setTotalComparisons(int n) {
        this._totalComparisons = n;
    }

    public int getActualComparisons() {
        return this._actualComparisons;
    }

    public void setActualComparisons(int n) {
        this._actualComparisons = n;
    }

    public String getName() {
        if (this._nBestList.size() > 0) {
            NBestResult r = this._nBestList.get(0);
            return r.getName();
        }
        return "";
    }

    public double getScore() {
        if (this._nBestList.size() > 0) {
            NBestResult r = this._nBestList.get(0);
            return r.getScore();
        }
        return -1.0;
    }

    public double getDistance() {
        if (this._nBestList.size() > 0) {
            NBestResult r = this._nBestList.get(0);
            return r.getDistance();
        }
        return -1.0;
    }

    public double getAngle() {
        if (this._nBestList.size() > 0) {
            NBestResult r = this._nBestList.get(0);
            return r.getAngle();
        }
        return 0.0;
    }

    public NBestResult get(int index) {
        if (index >= 0 && index < this._nBestList.size()) {
            return this._nBestList.get(index);
        }
        return null;
    }

    public String[] getNames() {
        String[] s = new String[this._nBestList.size()];
        if (this._nBestList.size() > 0) {
            int i = 0;
            while (i < s.length) {
                s[i] = this._nBestList.get(i).getName();
                ++i;
            }
        }
        return s;
    }

    public String getNamesString() {
        String s = "";
        if (this._nBestList.size() > 0) {
            for (NBestResult r : this._nBestList) {
                s = String.valueOf(s) + MessageFormat.format("{0},", r.getName());
            }
        }
        return s.replaceAll("[,]+$", "");
    }

    public double[] getScores() {
        double[] s = new double[this._nBestList.size()];
        if (this._nBestList.size() > 0) {
            int i = 0;
            while (i < s.length) {
                s[i] = this._nBestList.get(i).getScore();
                ++i;
            }
        }
        return s;
    }

    public String getScoresString() {
        String s = "";
        if (this._nBestList.size() > 0) {
            for (NBestResult r : this._nBestList) {
                s = String.valueOf(s) + MessageFormat.format("{0,number},", Utils.round(r.getScore(), 3));
            }
        }
        return s.replaceAll("[,]+$", "");
    }

    class NBestResult
    implements Comparable<NBestResult> {
        private String _name;
        private double _score;
        private double _distance;
        private double _angle;

        public NBestResult() {
            this._name = "";
            this._score = -1.0;
            this._distance = -1.0;
            this._angle = 0.0;
        }

        public NBestResult(String name, double score, double distance, double angle) {
            this._name = name;
            this._score = score;
            this._distance = distance;
            this._angle = angle;
        }

        public String getName() {
            return this._name;
        }

        public double getScore() {
            return this._score;
        }

        public double getDistance() {
            return this._distance;
        }

        public double getAngle() {
            return this._angle;
        }

        public boolean getIsEmpty() {
            return this._score == -1.0;
        }

        @Override
        public int compareTo(NBestResult r) {
            if (this._score < r._score) {
                return 1;
            }
            if (this._score > r._score) {
                return -1;
            }
            return 0;
        }
    }
}

