/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.recognizer.ndollar.Gesture;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import java.util.Collections;
import java.util.Vector;

public class Multistroke
implements Comparable<Multistroke> {
    public String Name;
    public String User;
    public String Speed;
    public int NumStrokes = -1;
    public Vector<Gesture> Gestures;
    public Gesture OriginalGesture;

    public Multistroke() {
        this.Name = "";
        this.User = "";
        this.Speed = "";
        this.Gestures = null;
        this.OriginalGesture = null;
    }

    public Multistroke(String name, String user, String spd, Vector<Vector<Point>> strokes) {
        this.Name = name;
        this.User = user;
        this.Speed = spd;
        Vector<Point> points = new Vector<Point>();
        for (Vector<Point> pts : strokes) {
            points.addAll(pts);
        }
        this.OriginalGesture = new Gesture(name, points);
        this.NumStrokes = strokes.size();
        if (!NDollarParameters.getInstance().ProcessUnistrokes && this.NumStrokes == 1) {
            this.Gestures = new Vector(1);
            this.Gestures.add(this.OriginalGesture);
        } else {
            Vector<Integer> defaultOrder = new Vector<Integer>(strokes.size());
            int i = 0;
            while (i < strokes.size()) {
                defaultOrder.add(i);
                ++i;
            }
            Vector<Vector<Integer>> allOrderings = new Vector<Vector<Integer>>();
            this.HeapPermute(this.NumStrokes, defaultOrder, allOrderings);
            Vector<Vector<Point>> unistrokes = this.MakeUnistrokes(strokes, allOrderings);
            this.Gestures = new Vector(unistrokes.size());
            for (Vector<Point> entry : unistrokes) {
                Gesture newG = new Gesture(this.Name, entry);
                this.Gestures.add(newG);
            }
        }
    }

    public void HeapPermute(int n, Vector<Integer> currentOrder, Vector<Vector<Integer>> allOrders) {
        if (n < 1) {
            return;
        }
        if (n == 1) {
            allOrders.add(new Vector<Integer>(currentOrder));
        } else {
            int i = 0;
            while (i < n) {
                this.HeapPermute(n - 1, currentOrder, allOrders);
                if (n % 2 == 1) {
                    this.SwapStrokes(0, n - 1, currentOrder);
                } else {
                    this.SwapStrokes(i, n - 1, currentOrder);
                }
                ++i;
            }
        }
    }

    private void SwapStrokes(int first, int second, Vector<Integer> order) {
        Collections.swap(order, first, second);
    }

    public Vector<Vector<Point>> MakeUnistrokes(Vector<Vector<Point>> originalStrokes, Vector<Vector<Integer>> allOrderings) {
        Vector<Vector<Point>> allUnistrokes = new Vector<Vector<Point>>();
        for (Vector<Integer> ordering : allOrderings) {
            int b = 0;
            while ((double)b < Math.pow(2.0, ordering.size())) {
                Vector unistroke = new Vector();
                int i = 0;
                while (i < ordering.size()) {
                    Vector stroke = new Vector(originalStrokes.elementAt(ordering.elementAt(i)));
                    if ((b >> i & 1) == 1) {
                        Collections.reverse(stroke);
                    }
                    unistroke.addAll(stroke);
                    ++i;
                }
                allUnistrokes.add(unistroke);
                ++b;
            }
        }
        return allUnistrokes;
    }

    @Override
    public int compareTo(Multistroke ms) {
        return this.Name.equals(ms.Name) ? 0 : 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Multistring{name=" + this.Name + ", ");
        buf.append("user=" + this.User + ", ");
        buf.append("speed=" + this.Speed + ", ");
        buf.append("gestures=[");
        int i = 0;
        while (i < this.Gestures.size()) {
            buf.append(String.valueOf(this.Gestures.elementAt((int)i).Name) + " ");
            ++i;
        }
        buf.append("]}");
        return buf.toString();
    }
}

