/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarRecognizer;
import eu.vicci.process.gesture.recognizer.ndollar.SamplesCollection;
import java.io.File;
import java.io.FilenameFilter;

public class Launcher {
    public static void main(String[] args) {
        String samplesDir = NDollarParameters.getInstance().SamplesDirectory;
        boolean include1D = NDollarParameters.getInstance().Include1D;
        boolean include2D = NDollarParameters.getInstance().Include2D;
        NDollarRecognizer _rec = new NDollarRecognizer();
        File currentDir = new File(samplesDir);
        File[] allXMLFiles = currentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        System.out.println("Number of files: " + allXMLFiles.length);
        SamplesCollection categoriesByUser = _rec.AssembleBatch(allXMLFiles, include1D, include2D);
        if (categoriesByUser != null) {
            if (_rec.TestBatch(categoriesByUser, currentDir.getPath())) {
                System.out.println("Testing complete.");
            } else {
                System.out.println("There was an error writing the output file during testing.");
            }
        } else {
            System.out.println("Unreadable files, or unbalanced number of gestures in categories.");
        }
    }
}

