/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.recognizer.ndollar.NBestList;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarRecognizer;
import eu.vicci.process.gesture.recognizer.ndollar.Utils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class GraphicLauncher
extends Frame
implements MouseMotionListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    static NDollarRecognizer _rec = null;
    Vector<Point> points = new Vector();
    Vector<Vector<Point>> strokes = new Vector();
    Image bufImage;
    Graphics bufG;
    Label recLabel;
    Button save;
    TextField input;

    public static void main(String[] args) {
        String samplesDir = NDollarParameters.getInstance().SamplesDirectory;
        _rec = new NDollarRecognizer();
        File currentDir = new File(samplesDir);
        File[] allXMLFiles = currentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        int i = 0;
        while (i < allXMLFiles.length) {
            _rec.LoadGesture(allXMLFiles[i]);
            ++i;
        }
        new GraphicLauncher();
    }

    public GraphicLauncher() {
        this.setTitle("$N Multistroke Recognizer in Java");
        this.setBounds(400, 300, 400, 400);
        this.setBackground(new Color(221, 221, 221));
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.recLabel = new Label("   left-click: draw    middle-click: clear canvas    right-click: recognize    ");
        this.recLabel.setBackground(new Color(255, 255, 136));
        this.recLabel.setSize(400, 20);
        this.add((Component)this.recLabel, "North");
        Panel savePanel = new Panel();
        savePanel.setBackground(new Color(236, 233, 216));
        savePanel.setLayout(new FlowLayout());
        this.save = new Button("save");
        this.save.addActionListener(this);
        this.input = new TextField("Type name here...");
        this.input.addActionListener(this);
        this.input.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                GraphicLauncher.this.input.selectAll();
            }
        });
        this.input.setColumns(20);
        savePanel.add(this.save);
        savePanel.add(this.input);
        this.add((Component)savePanel, "South");
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setColor(Color.RED);
        Enumeration<Vector<Point>> en = this.strokes.elements();
        while (en.hasMoreElements()) {
            Vector<Point> pts = en.nextElement();
            int i = 0;
            while (i < pts.size() - 1) {
                g2d.setColor(Color.RED);
                g2d.drawLine((int)pts.elementAt((int)i).X, (int)pts.elementAt((int)i).Y, (int)pts.elementAt((int)(i + 1)).X, (int)pts.elementAt((int)(i + 1)).Y);
                ++i;
            }
        }
        if (this.points.size() < 2) {
            return;
        }
        int i = 0;
        while (i < this.points.size() - 1) {
            g2d.setColor(Color.RED);
            g2d.drawLine((int)this.points.elementAt((int)i).X, (int)this.points.elementAt((int)i).Y, (int)this.points.elementAt((int)(i + 1)).X, (int)this.points.elementAt((int)(i + 1)).Y);
            ++i;
        }
    }

    @Override
    public void update(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.bufImage == null) {
            this.bufImage = this.createImage(w, h);
            this.bufG = this.bufImage.getGraphics();
        }
        this.bufG.setColor(this.getBackground());
        this.bufG.fillRect(0, 0, w, h);
        this.bufG.setColor(this.getForeground());
        this.paint(this.bufG);
        g.drawImage(this.bufImage, 0, 0, this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.points.add(new Point(e.getPoint().x, e.getPoint().y));
        this.recLabel.setText("Recording stroke #" + (this.strokes.size() + 1) + "...");
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.points.size() > 1) {
                this.strokes.add(new Vector<Point>(this.points));
                this.recLabel.setText("Stroke #" + this.strokes.size() + " recorded.");
            }
            this.points.clear();
        } else if (e.getButton() == 2) {
            this.strokes.clear();
            this.points.clear();
            this.recLabel.setText("Canvas cleared.");
        } else if (e.getButton() == 3 && this.strokes.size() > 0) {
            String resultTxt;
            Vector<Point> allPoints = new Vector<Point>();
            Enumeration<Vector<Point>> en = this.strokes.elements();
            while (en.hasMoreElements()) {
                Vector<Point> pts = en.nextElement();
                allPoints.addAll(pts);
            }
            NBestList result = _rec.Recognize(allPoints, this.strokes.size());
            if (result.getScore() == -1.0) {
                resultTxt = MessageFormat.format("No Match!\n[{0} out of {1} comparisons made]", result.getActualComparisons(), result.getTotalComparisons());
                this.recLabel.setText("No Match!");
            } else {
                resultTxt = MessageFormat.format("{0}: {1} ({2}px, {3}{4})  [{5,number,integer} out of {6,number,integer} comparisons made]", result.getName(), Utils.round(result.getScore(), 2), Utils.round(result.getDistance(), 2), Utils.round(result.getAngle(), 2), Character.valueOf('\u00b0'), result.getActualComparisons(), result.getTotalComparisons());
                this.recLabel.setText("Result: " + result.getName() + " (" + Utils.round(result.getScore(), 2) + ")");
            }
            System.out.println(resultTxt);
            this.points.clear();
        }
        this.repaint();
    }

    public void save(String name) {
        if (this.strokes == null || this.strokes.size() == 0) {
            this.recLabel.setText("Cannot save - no gesture!");
            return;
        }
        Vector<Integer> numPtsInStroke = new Vector<Integer>();
        Enumeration<Vector<Point>> en = this.strokes.elements();
        while (en.hasMoreElements()) {
            Vector<Point> pts = en.nextElement();
            numPtsInStroke.add(pts.size());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (_rec.SaveGesture(String.valueOf(NDollarParameters.getInstance().SamplesDirectory) + "\\" + name + "_" + dateFormat.format(GregorianCalendar.getInstance().getTime()) + ".xml", this.strokes, numPtsInStroke)) {
            this.recLabel.setText("Gesture saved.");
        } else {
            this.recLabel.setText("Gesture save failed.");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.save) || evt.getSource().equals(this.input)) {
            String name = this.input.getText();
            if (name != null && !name.equals("")) {
                this.save(name);
            } else {
                this.recLabel.setText("Cannot save gesture - no name provided!");
            }
        }
    }
}

