/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarRecognizer;
import eu.vicci.process.gesture.recognizer.ndollar.Utils;
import java.util.Vector;

public class Gesture
implements Comparable<Gesture> {
    public String Name = "";
    public Vector<Point> RawPoints;
    public Vector<Point> Points;
    public boolean Is1D;
    public Point StartUnitVector;
    public Vector<Double> VectorVersion;

    public Gesture() {
        this.RawPoints = null;
        this.Points = null;
        this.Is1D = true;
    }

    public Gesture(String name, Vector<Point> points) {
        this(points);
        this.Name = name;
    }

    public Gesture(Vector<Point> points) {
        this.RawPoints = new Vector<Point>(points);
        this.Points = this.RawPoints;
        this.Points = Utils.Resample(this.Points, NDollarParameters.getInstance().NumResamplePoints);
        double radians = Utils.AngleInRadians(Utils.Centroid(this.Points), this.Points.elementAt(0), false);
        this.Points = Utils.RotateByRadians(this.Points, -radians);
        this.Is1D = Utils.Is1DGesture(this.RawPoints);
        this.Points = Utils.Scale(this.Points, 0.3, NDollarRecognizer.ResampleScale);
        if (!NDollarParameters.getInstance().RotationInvariant) {
            this.Points = Utils.RotateByRadians(this.Points, radians);
        }
        this.Points = Utils.TranslateCentroidTo(this.Points, NDollarRecognizer.ResampleOrigin);
        this.StartUnitVector = Utils.CalcStartUnitVector(this.Points, NDollarParameters.getInstance().StartAngleIndex);
        this.VectorVersion = this.Vectorize(this.Points);
    }

    public int getDuration() {
        if (this.RawPoints.size() >= 2) {
            Point p0 = this.RawPoints.elementAt(0);
            Point pn = this.RawPoints.elementAt(this.RawPoints.size() - 1);
            return pn.T - p0.T;
        }
        return 0;
    }

    private Vector<Double> Vectorize(Vector<Point> pts) {
        double cos = 1.0;
        double sin = 0.0;
        if (!NDollarParameters.getInstance().RotationInvariant) {
            double iAngle = Math.atan2(pts.elementAt((int)0).Y, pts.elementAt((int)0).X);
            double baseOrientation = 0.7853981633974483 * Math.floor((iAngle + 0.39269908169872414) / 0.7853981633974483);
            cos = Math.cos(baseOrientation - iAngle);
            sin = Math.sin(baseOrientation - iAngle);
        }
        double sum = 0.0;
        Vector<Double> vector = new Vector<Double>();
        for (Point p : pts) {
            double newX = p.X * cos - p.Y * sin;
            double newY = p.Y * cos + p.X * sin;
            vector.add(newX);
            vector.add(newY);
            sum += newX * newX + newY * newY;
        }
        double magnitude = Math.sqrt(sum);
        int i = 0;
        while (i < vector.size()) {
            vector.setElementAt(vector.elementAt(i) / magnitude, i);
            ++i;
        }
        return vector;
    }

    @Override
    public int compareTo(Gesture g) {
        return this.Name.equals(g.Name) ? 0 : 1;
    }

    public static String ParseName(String filename) {
        int start = filename.lastIndexOf(92);
        int end = filename.lastIndexOf(95);
        return filename.substring(start + 1, end);
    }
}

