/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture.recognizer.ndollar;

import eu.vicci.process.gesture.recognizer.ndollar.Multistroke;
import java.util.Vector;

public class Category {
    private String _name;
    private Vector<Multistroke> _prototypes;

    public Category(String name) {
        this._name = name;
        this._prototypes = null;
    }

    public Category(String name, Multistroke firstExample) {
        this._name = name;
        this._prototypes = new Vector();
        this.AddExample(firstExample);
    }

    public Category(String name, Vector<Multistroke> examples) {
        this._name = name;
        this._prototypes = new Vector(examples.size());
        int i = 0;
        while (i < examples.size()) {
            Multistroke p = examples.elementAt(i);
            this.AddExample(p);
            ++i;
        }
    }

    public String getName() {
        return this._name;
    }

    public int getNumExamples() {
        return this._prototypes.size();
    }

    public Multistroke get(int i) {
        if (i >= 0 && i < this._prototypes.size()) {
            return this._prototypes.get(i);
        }
        return null;
    }

    public void AddExample(Multistroke p) {
        boolean success = true;
        try {
            String name = Category.ParseName(p.Name);
            if (!name.equals(this._name)) {
                throw new Exception("Prototype \"" + name + "\" does not equal the category \"" + this._name + "\" to which it was added.");
            }
            int i = 0;
            while (i < this._prototypes.size()) {
                Multistroke p0 = this._prototypes.get(i);
                if (p0.Name.equals(p.Name)) {
                    throw new Exception("Prototype \"" + p0.Name + "\" was added more than once to its category.");
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        if (success) {
            this._prototypes.add(p);
        }
    }

    public static String ParseName(String s) {
        String category = "";
        if (!s.contains("~")) {
            int i = s.length() - 1;
            while (i >= 0) {
                if (!Character.isDigit(s.charAt(i))) {
                    category = s.substring(0, i + 1);
                    break;
                }
                --i;
            }
        } else {
            category = s.substring(0, s.indexOf("~"));
        }
        return category;
    }
}

