/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.Point;
import java.util.ArrayList;
import java.util.List;

public class Stroke {
    private List<Point> points = new ArrayList<Point>();
    private List<Stroke> directNeighbours = new ArrayList<Stroke>();
    private boolean wasModified;
    private Point minPoint = new Point(Double.MAX_VALUE, Double.MAX_VALUE);
    private Point maxPoint = new Point(-1.7976931348623157E308, -1.7976931348623157E308);

    public void addDirectNeighbour(Stroke directNeighbour) {
        this.directNeighbours.add(directNeighbour);
    }

    public List<Stroke> getDirectNeighbours() {
        return this.directNeighbours;
    }

    public void calculateMinMax() {
        this.minPoint = new Point(Double.MAX_VALUE, Double.MAX_VALUE);
        this.maxPoint = new Point(0.0, 0.0);
        if (this.points.size() > 2) {
            for (Point pointR : this.points) {
                if (this.minPoint.X > pointR.X) {
                    this.minPoint.X = pointR.X;
                }
                if (this.maxPoint.X < pointR.X) {
                    this.maxPoint.X = pointR.X;
                }
                if (this.minPoint.Y > pointR.Y) {
                    this.minPoint.Y = pointR.Y;
                }
                if (!(this.maxPoint.Y < pointR.Y)) continue;
                this.maxPoint.Y = pointR.Y;
            }
        } else {
            this.minPoint = new Point(0.0, 0.0);
            this.maxPoint = new Point(0.0, 0.0);
        }
    }

    public void addPoint(Point point) {
        this.points.add(point);
        if (point.X > this.maxPoint.X) {
            this.maxPoint.X = point.X;
        }
        if (point.X < this.minPoint.X) {
            this.minPoint.X = point.X;
        }
        if (point.Y > this.maxPoint.Y) {
            this.maxPoint.Y = point.Y;
        }
        if (point.Y < this.minPoint.Y) {
            this.minPoint.Y = point.Y;
        }
    }

    public void addPointsOfStroke(Stroke stroke) {
        this.points.addAll(stroke.getPoints());
    }

    public void addNewPartOfStroke(Stroke stroke) {
        int i = 0;
        while (i < stroke.getSize()) {
            if (!this.points.contains(stroke.getPoint(i))) {
                this.points.add(stroke.getPoint(i));
            }
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public Point getPoint(int i) {
        return this.points.get(i);
    }

    public Integer getSize() {
        return this.points.size();
    }

    public Point getMinPoint() {
        return this.minPoint;
    }

    public Point getMaxPoint() {
        return this.maxPoint;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public List<Point> clearStroke() {
        return null;
    }

    public void setModified(boolean modified) {
        this.wasModified = modified;
    }

    public boolean hasModified() {
        return this.wasModified;
    }
}

