/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.BasicGesture;
import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.Stroke;
import eu.vicci.process.gesture.recognizer.ndollar.NBestList;
import java.util.Iterator;
import java.util.Set;

public class Result {
    BasicGesture gesture = new BasicGesture();
    NBestList recognitionResult = new NBestList();
    private Point centreBox;
    private Point startBox;
    private Point endBox;
    private int dimensionX;
    private int dimensionY;
    private Point firstPoint;
    private Point lastPoint;
    private String name;
    private double distance;
    private double angle;
    private double score;
    private String[] resultNamesInOrderOfRecognition;

    public void setGesture(BasicGesture basicGesture) {
        this.gesture = basicGesture;
        this.calculateAttributes();
    }

    public void setRecognitionResult(NBestList result) {
        this.recognitionResult = result;
        this.setName(this.recognitionResult.getName());
        this.score = result.getScore();
        this.distance = result.getDistance();
        this.angle = result.getAngle();
        this.resultNamesInOrderOfRecognition = result.getNames();
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void calculateAttributes() {
        Set<Stroke> strokes = this.gesture.getStrokes();
        int it = 0;
        Point minX = new Point(Double.MAX_VALUE, Double.MAX_VALUE);
        Point maxX = new Point(0.0, 0.0);
        Point minY = new Point(Double.MAX_VALUE, Double.MAX_VALUE);
        Point maxY = new Point(0.0, 0.0);
        Stroke stroke = new Stroke();
        Iterator<Stroke> iterator = strokes.iterator();
        while (iterator.hasNext()) {
            stroke = iterator.next();
            stroke.calculateMinMax();
            if (it == 0) {
                this.firstPoint = new Point(stroke.getPoint((int)0).X, stroke.getPoint((int)0).Y);
            }
            if (minX.X > stroke.getMinPoint().X) {
                minX = stroke.getMinPoint();
            }
            if (maxX.X < stroke.getMaxPoint().X) {
                maxX = stroke.getMaxPoint();
            }
            if (minY.Y > stroke.getMinPoint().Y) {
                minY = stroke.getMinPoint();
            }
            if (maxY.Y < stroke.getMaxPoint().Y) {
                maxY = stroke.getMaxPoint();
            }
            if (!iterator.hasNext()) {
                int size = stroke.getSize() - 1;
                this.lastPoint = new Point(stroke.getPoint((int)size).X, stroke.getPoint((int)size).Y);
            }
            ++it;
        }
        this.dimensionX = (int)(maxX.X - minX.X);
        this.dimensionY = (int)(maxY.Y - minY.Y);
        this.startBox = new Point(minX.X, minY.Y);
        this.endBox = new Point(maxX.X, maxY.Y);
        this.centreBox = new Point((maxX.X - minX.X) / 2.0, (maxY.Y - minY.Y) / 2.0);
    }

    public BasicGesture getGesture() {
        return this.gesture;
    }

    public NBestList getRecognitionResult() {
        return this.recognitionResult;
    }

    public Point getCentreBox() {
        return this.centreBox;
    }

    public Point getStartBox() {
        return this.startBox;
    }

    public Point getEndBox() {
        return this.endBox;
    }

    public int getDimensionX() {
        return this.dimensionX;
    }

    public int getDimensionY() {
        return this.dimensionY;
    }

    public Point getFirstPoint() {
        return this.firstPoint;
    }

    public Point getLastPoint() {
        return this.lastPoint;
    }

    public String getName() {
        return this.name;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getScore() {
        return this.score;
    }

    public String[] getResultNamesInOrderOfRecognition() {
        return this.resultNamesInOrderOfRecognition;
    }
}

