/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.recognizer.ndollar.Utils;
import java.text.DecimalFormat;

public class Rectangle {
    private static final int Digits = 4;
    private double _x;
    private double _y;
    private double _width;
    private double _height;
    public static final Rectangle Empty = new Rectangle(0.0, 0.0, 0.0, 0.0);
    DecimalFormat df = new DecimalFormat("#.###");

    public Rectangle(double x, double y, double width, double height) {
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
    }

    public Rectangle(Rectangle r) {
        this._x = r.getX();
        this._y = r.getY();
        this._width = r.getWidth();
        this._height = r.getHeight();
    }

    public double getX() {
        return Utils.round(this._x, 4);
    }

    public void setX(double value) {
        this._x = value;
    }

    public double getY() {
        return Utils.round(this._y, 4);
    }

    public void setY(double value) {
        this._y = value;
    }

    public double getWidth() {
        return Utils.round(this._width, 4);
    }

    public void setWidth(double value) {
        this._width = value;
    }

    public double getHeight() {
        return Utils.round(this._height, 4);
    }

    public void setHeight(double value) {
        this._height = value;
    }

    public Point getTopLeft() {
        return new Point(this.getX(), this.getY());
    }

    public Point getBottomRight() {
        return new Point(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    public Point getCenter() {
        return new Point(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight() / 2.0);
    }

    public double getMaxSide() {
        return Math.max(this._width, this._height);
    }

    public double getMinSide() {
        return Math.min(this._width, this._height);
    }

    public double getDiagonal() {
        return Utils.Distance(this.getTopLeft(), this.getBottomRight());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return this.getX() == r.getX() && this.getY() == r.getY() && this.getWidth() == r.getWidth() && this.getHeight() == r.getHeight();
        }
        return false;
    }
}

