/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.BasicGesture;
import eu.vicci.process.gesture.Interval;
import eu.vicci.process.gesture.Stroke;
import java.util.ArrayList;
import java.util.List;

public class PreProcessor {
    public static final double strokeTolerance = 80.0;
    private static final int coverage = 1;
    private List<BasicGesture> gestures = new ArrayList<BasicGesture>();
    List<BasicGesture> findBasicGestures = new ArrayList<BasicGesture>();
    BasicGesture finishedBasicGesture = new BasicGesture();
    int timerOffset;
    int finishOffset;

    public BasicGesture preProcess(List<Stroke> strokes) {
        BasicGesture finishedGesture = new BasicGesture();
        this.findDirectNeighbour(strokes);
        this.findBasicGestures = this.findBasicGestures(strokes);
        finishedGesture = this.gestureFinished(this.findBasicGestures);
        return finishedGesture;
    }

    public List<BasicGesture> process(List<Stroke> strokes) {
        ArrayList<BasicGesture> findBasicGestures = new ArrayList();
        this.findDirectNeighbour(strokes);
        findBasicGestures = this.findBasicGestures(strokes);
        return findBasicGestures;
    }

    public void findDirectNeighbour(List<Stroke> strokes) {
        int startSecondStrokeIndex = 0;
        Stroke firstStroke = new Stroke();
        if (strokes.size() > 1) {
            int x = 0;
            while (x < strokes.size()) {
                firstStroke = strokes.get(x);
                firstStroke.calculateMinMax();
                Interval miMaX1 = new Interval(firstStroke.getMinPoint().X - 80.0, firstStroke.getMaxPoint().X + 80.0);
                Interval miMaY1 = new Interval(firstStroke.getMinPoint().Y - 80.0, firstStroke.getMaxPoint().Y + 80.0);
                int y = startSecondStrokeIndex;
                while (y < strokes.size()) {
                    if (x != y) {
                        Stroke secondStroke = strokes.get(y);
                        secondStroke.calculateMinMax();
                        Interval miMaX2 = new Interval(secondStroke.getMinPoint().X, secondStroke.getMaxPoint().X);
                        Interval miMaY2 = new Interval(secondStroke.getMinPoint().Y, secondStroke.getMaxPoint().Y);
                        if (miMaX2.percent(miMaX1) > 1.0 && miMaY2.percent(miMaY1) > 1.0) {
                            firstStroke.addDirectNeighbour(secondStroke);
                        }
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public List<BasicGesture> findBasicGestures(List<Stroke> strokes) {
        int i = 0;
        while (i < strokes.size()) {
            boolean contains = false;
            int j = 0;
            while (j < this.gestures.size()) {
                if (this.gestures.get(j).getStrokes().contains(strokes.get(i))) {
                    if (strokes.get(i).getDirectNeighbours().size() > 0) {
                        this.findRelatedStrokes(strokes.get(i), this.gestures.get(j));
                    }
                    contains = true;
                    break;
                }
                ++j;
            }
            if (!contains) {
                BasicGesture newGesture = new BasicGesture();
                this.findRelatedStrokes(strokes.get(i), newGesture);
                this.gestures.add(newGesture);
            }
            j = 0;
            while (j < this.gestures.size()) {
                int j2 = 0;
                while (j2 < this.gestures.size()) {
                    int j3 = 0;
                    while (j3 < strokes.size()) {
                        if (this.gestures.get(j).getStrokes().contains(strokes.get(j3)) && this.gestures.get(j2).getStrokes().contains(strokes.get(j3)) && j != j2) {
                            System.out.println("Delete Subgesture");
                            if (this.gestures.get(j).getStrokes().size() > this.gestures.get(j2).getStrokes().size()) {
                                this.gestures.remove(this.gestures.get(j2));
                                break;
                            }
                            if (this.gestures.get(j).getStrokes().size() < this.gestures.get(j2).getStrokes().size()) {
                                this.gestures.remove(this.gestures.get(j));
                                break;
                            }
                        }
                        ++j3;
                    }
                    ++j2;
                }
                ++j;
            }
            ++i;
        }
        return this.gestures;
    }

    private void findRelatedStrokes(Stroke stroke, BasicGesture gesture) {
        gesture.addStroke(stroke);
        List<Stroke> directNeighbours = stroke.getDirectNeighbours();
        int i = 0;
        while (i < directNeighbours.size()) {
            Stroke neighbour = directNeighbours.get(i);
            if (!gesture.getStrokes().contains(neighbour)) {
                this.findRelatedStrokes(neighbour, gesture);
            }
            ++i;
        }
    }

    private BasicGesture gestureFinished(List<BasicGesture> gestures) {
        int i = 0;
        while (i < gestures.size()) {
            this.finishedBasicGesture = gestures.get(i);
            if (!this.finishedBasicGesture.getFinished()) {
                if (this.finishedBasicGesture.hasModified() && this.timerOffset < this.finishOffset) {
                    this.finishedBasicGesture.setPointsAtTime(this.finishedBasicGesture.getAllPoints().size());
                } else {
                    this.finishedBasicGesture.isFinished(true);
                    System.out.println(" PreProcessor gestureFinished " + this.finishedBasicGesture.getFinished());
                    gestures.remove(this.finishedBasicGesture);
                    break;
                }
            }
            ++i;
        }
        return this.finishedBasicGesture;
    }

    public void setTimerOffset(int tOffset) {
        this.timerOffset = tOffset;
    }

    public void setFinishOffset(int fOffset) {
        this.finishOffset = fOffset;
    }

    public void clear() {
        this.finishedBasicGesture.clear();
        this.gestures.clear();
        this.findBasicGestures.clear();
        this.finishOffset = 0;
        this.timerOffset = 0;
    }
}

