/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.recognizer.ndollar.NBestList;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarParameters;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarRecognizer;
import eu.vicci.process.gesture.recognizer.ndollar.Utils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.widgets.Touch;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelEditor
extends Frame
implements MouseMotionListener,
MouseListener,
ActionListener,
MouseMoveListener {
    private static final long serialVersionUID = 6137493782116306484L;
    private static NDollarRecognizer recognizer = null;
    private static String samplesDir = "samples" + File.separator + "staticSamples";
    private Vector<Point> points = new Vector();
    private Vector<Point> touchPoints = new Vector();
    private Vector<Vector<Point>> strokes = new Vector();
    private Vector<Vector<Point>> touchStrokes = new Vector();
    private Image bufImage;
    private Graphics bufG;
    private Label infoLabel;
    private Button save;
    private Button load;
    private Button recognize;
    private Button clear;
    private Button reloadModel;
    private TextField saveName;
    private TextField loadFile;

    public static void main(String[] args) {
        recognizer = new NDollarRecognizer();
        ModelEditor.readSamples();
        new ModelEditor();
    }

    public void touch(TouchEvent event) {
        Touch[] touches = event.touches;
        System.out.println("touches.length" + touches.length);
        int i = 0;
        while (i < touches.length) {
            Touch currentTouch = touches[i];
            if (currentTouch.state == 1) {
                System.out.println("touch start");
                this.touchPoints.add(new Point(currentTouch.x, currentTouch.y));
                this.touchStrokes.add(this.touchPoints);
            }
            this.touchPoints = this.touchStrokes.elementAt(i);
            if (currentTouch.state == 2) {
                System.out.println("touch wird ausgefuehrt");
                this.touchPoints.add(new Point(currentTouch.x, currentTouch.y));
                this.touchStrokes.set(i, this.touchPoints);
            } else if (currentTouch.state == 4) {
                System.out.println("touch ende");
                this.touchPoints.add(new Point(currentTouch.x, currentTouch.y));
                this.touchStrokes.remove(i);
                this.strokes.addAll(this.touchStrokes);
            }
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setColor(Color.BLACK);
        Enumeration<Vector<Point>> en = this.strokes.elements();
        while (en.hasMoreElements()) {
            Vector<Point> _points = en.nextElement();
            int i = 0;
            while (i < _points.size() - 1) {
                g2d.setColor(Color.BLACK);
                g2d.drawLine((int)_points.elementAt((int)i).X, (int)_points.elementAt((int)i).Y, (int)_points.elementAt((int)(i + 1)).X, (int)_points.elementAt((int)(i + 1)).Y);
                ++i;
            }
        }
        if (this.points.size() < 2) {
            return;
        }
        int i = 0;
        while (i < this.points.size() - 1) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine((int)this.points.get((int)i).X, (int)this.points.get((int)i).Y, (int)this.points.get((int)(i + 1)).X, (int)this.points.get((int)(i + 1)).Y);
            ++i;
        }
    }

    @Override
    public void update(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.bufImage == null) {
            this.bufImage = this.createImage(w, h);
            this.bufG = this.bufImage.getGraphics();
        }
        this.bufG.setColor(this.getBackground());
        this.bufG.fillRect(0, 0, w, h);
        this.bufG.setColor(this.getForeground());
        this.paint(this.bufG);
        g.drawImage(this.bufImage, 0, 0, this);
    }

    public ModelEditor() {
        this.setTitle("Model Editor");
        this.setBounds(0, 0, 2550, 1400);
        this.setBackground(new Color(221, 221, 0));
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.infoLabel = new Label("                                 Draw gesture in the green field.                                          Do some activities at toolpanel below. ");
        this.infoLabel.setBackground(new Color(255, 255, 255));
        this.infoLabel.setSize(600, 20);
        this.add((Component)this.infoLabel, "North");
        Panel toolPanel = new Panel();
        toolPanel.setBackground(new Color(100, 100, 100));
        toolPanel.setLayout(new FlowLayout());
        this.clear = new Button("clear");
        this.clear.addActionListener(this);
        this.recognize = new Button("recognize");
        this.recognize.addActionListener(this);
        this.load = new Button("Load model file");
        this.load.addActionListener(this);
        this.loadFile = new TextField("Loaded modelname");
        this.reloadModel = new Button("Reload models");
        this.reloadModel.addActionListener(this);
        this.save = new Button("Save model");
        this.save.addActionListener(this);
        this.saveName = new TextField("Type modelname here...");
        this.saveName.setColumns(20);
        toolPanel.add(this.load);
        toolPanel.add(this.loadFile);
        toolPanel.add(this.recognize);
        toolPanel.add(this.clear);
        toolPanel.add(this.save);
        toolPanel.add(this.saveName);
        toolPanel.add(this.reloadModel);
        this.add((Component)toolPanel, "South");
        this.setVisible(true);
    }

    private void openLoadDialog() {
        JFileChooser chooser = new JFileChooser(samplesDir);
        int getBack = chooser.showOpenDialog(null);
        if (getBack == 0 && this.checkFile(chooser.getSelectedFile().getAbsolutePath())) {
            chooser.getSelectedFile().getName();
            this.loadNdollarModel(chooser.getSelectedFile().getAbsolutePath());
            System.out.println("Die zu oeffnende Datei ist: " + chooser.getSelectedFile().getAbsolutePath());
            this.infoLabel.setText("Load File: " + chooser.getSelectedFile().getAbsolutePath());
        } else {
            this.infoLabel.setText("Failure ");
            System.out.println("Failure: can't read file ");
        }
    }

    private void recognize() {
        if (this.strokes.size() > 0) {
            String resultText;
            Vector<Point> allPoints = new Vector<Point>();
            Enumeration<Vector<Point>> en = this.strokes.elements();
            while (en.hasMoreElements()) {
                Vector<Point> _points = en.nextElement();
                allPoints.addAll(_points);
            }
            NBestList result = recognizer.Recognize(allPoints, this.strokes.size());
            if (result.getScore() == -1.0) {
                resultText = MessageFormat.format("No Match!\n[{0} out of {1} comparisons made]", result.getActualComparisons(), result.getTotalComparisons());
                this.infoLabel.setText("No Match!");
            } else {
                resultText = MessageFormat.format("{0}: {1} ({2}px, {3}{4})  [{5,number,integer} out of {6,number,integer} comparisons made]", result.getName(), Utils.round(result.getScore(), 2), Utils.round(result.getDistance(), 2), Utils.round(result.getAngle(), 2), Character.valueOf('\u00b0'), result.getActualComparisons(), result.getTotalComparisons());
                this.infoLabel.setText("Result: " + result.getName() + " (" + Utils.round(result.getScore(), 2) + ")");
            }
            System.out.println(resultText);
            this.points.clear();
        }
        this.repaint();
    }

    public void save(String name) {
        if (this.strokes == null || this.strokes.size() == 0) {
            this.infoLabel.setText("Cannot save - no gesture!");
            return;
        }
        Vector<Integer> numberPointsInStroke = new Vector<Integer>();
        Enumeration<Vector<Point>> en = this.strokes.elements();
        while (en.hasMoreElements()) {
            Vector<Point> pts = en.nextElement();
            numberPointsInStroke.add(pts.size());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (recognizer.SaveGesture(String.valueOf(NDollarParameters.getInstance().SamplesDirectory) + File.separator + name + "_" + dateFormat.format(GregorianCalendar.getInstance().getTime()) + ".xml", this.strokes, numberPointsInStroke)) {
            this.infoLabel.setText("Gesture saved.");
        } else {
            this.infoLabel.setText("Gesture save failed.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.load) {
            System.out.println("load Button");
            this.openLoadDialog();
        } else if (event.getSource() == this.save || event.getSource().equals(this.saveName)) {
            this.saveName.selectAll();
            String name = this.saveName.getText();
            if (name != null && !name.equals("")) {
                this.save(name);
            } else {
                this.infoLabel.setText("Cannot save gesture - no name provided!");
            }
            System.out.println("save Button");
        } else if (event.getSource() == this.recognize) {
            System.out.println("recognize Button");
            this.recognize();
        } else if (event.getSource() == this.clear) {
            this.strokes.clear();
            this.points.clear();
            this.infoLabel.setText("Input cleared");
            System.out.println("clear Canvas");
            this.repaint();
        } else if (event.getSource() == this.reloadModel) {
            recognizer = new NDollarRecognizer();
            ModelEditor.readSamples();
        }
    }

    public boolean checkFile(String file) {
        try {
            File nDollarFile = new File(file);
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dBuilder.parse(nDollarFile);
            if (doc.getDocumentElement().getAttribute("AppName") == "NDollarRecognizer-java") {
                // empty if block
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void loadNdollarModel(String path) {
        try {
            File nDollarFile = new File(path);
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dBuilder.parse(nDollarFile);
            NodeList gestureList = doc.getDocumentElement().getChildNodes();
            this.loadFile.setText(doc.getDocumentElement().getAttribute("Name"));
            int i = 0;
            while (i < gestureList.getLength()) {
                Node strokeNode = gestureList.item(i);
                if (strokeNode.getNodeName().equals("Stroke")) {
                    NodeList pointList = strokeNode.getChildNodes();
                    int j = 0;
                    while (j < pointList.getLength()) {
                        Node pointNode = pointList.item(j);
                        if (pointNode.getNodeName().equals("Point")) {
                            this.points.add(new Point(Double.parseDouble(pointNode.getAttributes().getNamedItem("X").getNodeValue()), Double.parseDouble(pointNode.getAttributes().getNamedItem("Y").getNodeValue())));
                        }
                        ++j;
                    }
                    this.strokes.add(new Vector<Point>(this.points));
                    this.points.clear();
                    this.repaint();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readSamples() {
        File currentDir = new File(samplesDir);
        File[] allXMLFiles = currentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        System.out.println("allXMLFiles.lenght" + allXMLFiles.length);
        int i = 0;
        while (i < allXMLFiles.length) {
            System.out.println(allXMLFiles.length);
            recognizer.LoadGesture(allXMLFiles[i]);
            ++i;
        }
    }

    public void mouseMove(org.eclipse.swt.events.MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.points.size() > 1) {
            this.strokes.add(new Vector<Point>(this.points));
            this.infoLabel.setText("Stroke #" + this.strokes.size() + " recorded.");
        }
        this.points.clear();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        System.out.println("Mouse " + e.toString());
        this.points.add(new Point(e.getPoint().x, e.getPoint().y));
        this.infoLabel.setText("Recording stroke #" + (this.strokes.size() + 1) + "...");
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

