/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

public class Interval {
    private double min;
    private double max;

    public Interval(double min, double max) {
        assert (min <= max);
        this.min = min;
        this.max = max;
    }

    public void setMin(int le) {
        this.min = le;
    }

    public void setMax(int re) {
        this.min = re;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean intersects(Interval b) {
        Interval a = this;
        if (b.min <= a.max && b.min >= a.min) {
            return true;
        }
        return a.min <= b.max && a.min >= b.min;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }

    public double amount(Interval b) {
        double amount = this.max - b.min;
        return amount;
    }

    public double percent(Interval b) {
        Interval a = this;
        double percent = 100.0 / (b.max - a.min) * a.amount(b);
        return percent;
    }

    public boolean more(Interval b) {
        Interval a = this;
        return a.max < b.max;
    }

    public boolean less(Interval b) {
        Interval a = this;
        return a.min > b.min;
    }

    public boolean subset(Interval b) {
        Interval a = this;
        return a.min >= b.min && a.max <= b.max;
    }
}

