/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.BasicGesture;
import eu.vicci.process.gesture.Interval;
import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.Result;
import eu.vicci.process.gesture.Stroke;
import eu.vicci.process.gesture.recognizer.ndollar.Multistroke;
import eu.vicci.process.gesture.recognizer.ndollar.NBestList;
import eu.vicci.process.gesture.recognizer.ndollar.NDollarRecognizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParserException;

public class GestureRecognizer {
    private static String staticSamplesDir = "/samples/staticSamples";
    private static String samplesRecDir = "/samples/Records";
    private int processingStep;
    private boolean saveGestures = false;
    static NDollarRecognizer staticRecognizer = new NDollarRecognizer();

    public Result staticRecognize(BasicGesture basicGesture) {
        BasicGesture _basicGesture = new BasicGesture();
        _basicGesture = basicGesture;
        Vector<Point> allPoints = new Vector<Point>();
        allPoints.addAll(basicGesture.getAllPoints());
        NBestList resultBestStaticMatch = new NBestList();
        Result result = new Result();
        boolean recognized = false;
        if (allPoints.size() > 4) {
            if (basicGesture.size() == 1 && basicGesture.getStroke(1).getSize() < 25) {
                basicGesture.getStroke(1).calculateMinMax();
                Interval tapRangeX = new Interval(0.0, 10.0);
                Interval tapRangeY = new Interval(0.0, 10.0);
                Interval rangeX = new Interval(0.0, basicGesture.getStroke((int)1).getMaxPoint().X - basicGesture.getStroke((int)1).getMinPoint().X);
                Interval rangeY = new Interval(0.0, basicGesture.getStroke((int)1).getMaxPoint().Y - basicGesture.getStroke((int)1).getMinPoint().Y);
                if (rangeX.subset(tapRangeX) && rangeY.subset(tapRangeY)) {
                    basicGesture.isFinished(true);
                    result.setGesture(basicGesture);
                    result.setName("tap");
                    recognized = true;
                }
            }
        } else {
            System.out.println("zu wenig Punkte");
        }
        if (!recognized) {
            resultBestStaticMatch = staticRecognizer.Recognize(allPoints, basicGesture.getStrokes().size());
            result.setGesture(basicGesture);
            result.setRecognitionResult(resultBestStaticMatch);
        }
        this.save(_basicGesture);
        return result;
    }

    public static void readSamples() {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"eu.vicci.process.gesture"), (IPath)new Path(staticSamplesDir), null);
        try {
            File directory = new File(FileLocator.resolve((URL)url).toURI());
            File[] allStaticXMLFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            int i = 0;
            while (i < allStaticXMLFiles.length) {
                staticRecognizer.LoadGesture(allStaticXMLFiles[i]);
                ++i;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean addGesture(String gestureXML) {
        MXParser parser = new MXParser();
        try {
            parser.setInput((InputStream)new ByteArrayInputStream(gestureXML.getBytes("UTF-8")), "UTF-8");
            staticRecognizer.AddGestureFromXML(parser);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void save(BasicGesture gesture) {
        BasicGesture _basicGesture = gesture;
        Vector<Vector<Point>> _strokes = new Vector<Vector<Point>>();
        int i = 0;
        while (i < _basicGesture.size()) {
            Vector<Point> _points = new Vector<Point>();
            Stroke stroke = _basicGesture.getStroke(i);
            int j = 0;
            while (j < stroke.getSize()) {
                _points.add(stroke.getPoint(j));
                ++j;
            }
            _strokes.add(_points);
            ++i;
        }
        if (_strokes == null || _strokes.size() == 0) {
            return;
        }
        Vector<Integer> numberPointsInStroke = new Vector<Integer>();
        Enumeration en = _strokes.elements();
        while (en.hasMoreElements()) {
            Vector pts = (Vector)en.nextElement();
            numberPointsInStroke.add(pts.size());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String gestureName = "Touch-Record_" + dateFormat.format(GregorianCalendar.getInstance().getTime());
        if (this.saveGestures) {
            NDollarRecognizer dummy = new NDollarRecognizer();
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)"eu.vicci.process.gesture"), (IPath)new Path(samplesRecDir), null);
            try {
                URI uri = FileLocator.resolve((URL)url).toURI();
                dummy.SaveGesture(String.valueOf(uri.getRawPath()) + gestureName + ".xml", _strokes, numberPointsInStroke);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Result continousRecognize(BasicGesture basicGesture) {
        Result continousResult = new Result();
        if (basicGesture.size() == 2) {
            int size1 = basicGesture.getStroke(1).getSize() - 1;
            int size2 = basicGesture.getStroke(2).getSize() - 1;
            Point point1 = new Point(basicGesture.getStroke((int)1).getPoint((int)size1).X, basicGesture.getStroke((int)1).getPoint((int)size1).Y);
            Point point2 = new Point(basicGesture.getStroke((int)2).getPoint((int)size2).X, basicGesture.getStroke((int)1).getPoint((int)size2).Y);
            Interval s1X = new Interval(point1.X - 35.0, point1.X + 35.0);
            Interval s1Y = new Interval(point1.Y - 35.0, point1.Y + 35.0);
            Interval s2X = new Interval(point2.X - 35.0, point2.X + 35.0);
            Interval s2Y = new Interval(point2.Y - 35.0, point2.Y + 35.0);
            if (s1X.intersects(s2X) && s1Y.intersects(s2Y)) {
                continousResult.setGesture(basicGesture);
                continousResult.getGesture().setContinous(true);
                continousResult.setName("drag");
            }
        }
        return continousResult;
    }

    public int getProcessingStep() {
        return this.processingStep;
    }

    public void setProcessingStep(int prosessingStep) {
        this.processingStep = prosessingStep;
    }

    public Hashtable<String, Multistroke> getGestures() {
        return staticRecognizer.getGestures();
    }
}

