/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.Editor;
import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.recognizer.ndollar.Gesture;
import eu.vicci.process.gesture.recognizer.ndollar.Multistroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.graphiti.ui.editor.DefaultPaletteBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class GesturePaletteBehavior
extends DefaultPaletteBehavior {
    public GesturePaletteBehavior(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
    }

    private void bresenham(int x0, int y0, int x1, int y1, ImageData image, int color) {
        double dx = Math.abs(x1 - x0);
        double dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        double err = dx - dy;
        while (true) {
            image.setPixel(x0, y0, color);
            if (x0 == x1 && y0 == y1) {
                return;
            }
            double e2 = 2.0 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (x0 == x1 && y0 == y1) {
                image.setPixel(x0, y0, color);
                return;
            }
            if (!(e2 < dx)) continue;
            err += dx;
            y0 += sy;
        }
    }

    protected PaletteRoot createPaletteRoot() {
        PaletteRoot root = super.createPaletteRoot();
        PaletteDrawer drawer = new PaletteDrawer("Gestures");
        IDiagramContainerUI container = this.diagramBehavior.getDiagramContainer();
        if (container instanceof Editor) {
            Hashtable<String, Multistroke> gestures = ((Editor)container).getGestures();
            ArrayList<String> keys = Collections.list(gestures.keys());
            Collections.sort(keys);
            for (String name : keys) {
                ImageData data = new ImageData(24, 24, 8, new PaletteData(255, 255, 255));
                int y = 0;
                while (y < 24) {
                    int x = 0;
                    while (x < 24) {
                        data.setPixel(x, y, 255);
                        ++x;
                    }
                    ++y;
                }
                Point min = new Point(Double.MAX_VALUE, Double.MAX_VALUE);
                Point max = new Point(-1.7976931348623157E308, -1.7976931348623157E308);
                Gesture g = gestures.get((Object)name).OriginalGesture;
                for (Point p : g.Points) {
                    if (p.X < min.X) {
                        min.X = p.X;
                    }
                    if (p.Y < min.Y) {
                        min.Y = p.Y;
                    }
                    if (p.X > max.X) {
                        max.X = p.X;
                    }
                    if (!(p.Y > max.Y)) continue;
                    max.Y = p.Y;
                }
                Point last = null;
                for (Point p : g.Points) {
                    int x = Math.min((int)((p.X - min.X) / (max.X - min.X) * 23.0), 23);
                    int y2 = Math.min((int)((p.Y - min.Y) / (max.Y - min.Y) * 23.0), 23);
                    if (last != null) {
                        this.bresenham((int)last.X, (int)last.Y, x, y2, data, 0);
                    }
                    last = new Point(x, y2);
                }
                ImageDescriptor image = ImageDescriptor.createFromImageData((ImageData)data);
                PaletteEntry entry = new PaletteEntry(name, null, image, image);
                drawer.add((org.eclipse.gef.palette.PaletteEntry)entry);
            }
        }
        root.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        return root;
    }

    private class PaletteEntry
    extends ToolEntry {
        public PaletteEntry(String label, String shortDesc, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
            super(label, shortDesc, iconSmall, iconLarge);
        }
    }
}

