/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.gesture;

import eu.vicci.process.gesture.BasicGesture;
import eu.vicci.process.gesture.DebugStream;
import eu.vicci.process.gesture.GestureRecognizer;
import eu.vicci.process.gesture.GestureResultListener;
import eu.vicci.process.gesture.Point;
import eu.vicci.process.gesture.PreProcessor;
import eu.vicci.process.gesture.Result;
import eu.vicci.process.gesture.Stroke;
import eu.vicci.process.gesture.recognizer.ndollar.Multistroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Touch;

public class Editor
extends DiagramEditor
implements MouseMoveListener,
MouseListener,
GestureListener,
TouchListener,
PaintListener {
    private boolean mouseDown = false;
    private boolean mouse = false;
    private boolean touchDown = false;
    private boolean touch = false;
    private boolean gesture = false;
    private PreProcessor preProcessor = new PreProcessor();
    private List<Stroke> strokes = new ArrayList<Stroke>();
    private GestureRecognizer recognizer = new GestureRecognizer();
    private Stroke currentStroke = new Stroke();
    private Map<Long, Stroke> currentTouchStrokes = new HashMap<Long, Stroke>();
    private List<BasicGesture> findBasicGestures = new ArrayList<BasicGesture>();
    private Stroke currentMouseStroke;
    private boolean newStroke;
    private int timerOffset;
    private static final int timerTime = 55;
    private Timer timer;
    public static TimerTask timertask;
    private static final int finishOffset = 7;
    private List<GestureResultListener> gestureResultListeners = new LinkedList<GestureResultListener>();
    private static Semaphore recDelSemaphore;

    static {
        DebugStream.activate();
        recDelSemaphore = new Semaphore(1, true);
    }

    public Editor() {
        GestureRecognizer.readSamples();
    }

    protected void createGraphicalViewer(Composite parent) {
        super.createGraphicalViewer(parent);
        this.getGraphicalViewer().getControl().addGestureListener((GestureListener)this);
        this.getGraphicalViewer().getControl().setTouchEnabled(true);
        this.getGraphicalViewer().getControl().addTouchListener((TouchListener)this);
        this.getGraphicalViewer().getControl().addMouseListener((MouseListener)this);
        this.getGraphicalViewer().getControl().addMouseMoveListener((MouseMoveListener)this);
        this.getGraphicalViewer().getControl().addPaintListener((PaintListener)this);
    }

    public void gesture(GestureEvent event) {
        this.gesture = true;
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>GESTE<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        if (!this.touchDown && !this.mouseDown) {
            if (event.detail == 2) {
                System.out.println("Gesture Start " + event.detail);
            }
            if (event.detail == 4) {
                System.out.println("Gesture End " + event.detail);
            }
        }
    }

    public void touch(TouchEvent event) {
        if (!this.mouse && !this.gesture) {
            this.touch = true;
            Touch[] touches = event.touches;
            int i = 0;
            while (i < touches.length) {
                Touch currentTouch = touches[i];
                FigureCanvas canvas = (FigureCanvas)this.getGraphicalControl();
                org.eclipse.swt.graphics.Point canvasOrigin = canvas.toDisplay(0, 0);
                if (currentTouch.state == 1) {
                    this.currentStroke = new Stroke();
                    this.currentStroke.addPoint(new Point(currentTouch.x - canvasOrigin.x, currentTouch.y - canvasOrigin.y));
                    this.currentTouchStrokes.put(currentTouch.id, this.currentStroke);
                    this.strokes.add(this.currentStroke);
                    this.timerStart(55L);
                    this.touchDown = true;
                    this.timerOffset = 0;
                } else if (currentTouch.state == 2) {
                    this.currentStroke = this.currentTouchStrokes.get(currentTouch.id);
                    if (this.currentStroke != null) {
                        int temp = this.strokes.indexOf(this.currentStroke);
                        this.currentStroke.addPoint(new Point(currentTouch.x - canvasOrigin.x, currentTouch.y - canvasOrigin.y));
                        this.strokes.remove(temp);
                        this.strokes.add(this.currentStroke);
                        this.touchDown = true;
                    }
                    Point min = this.currentStroke.getMinPoint();
                    Point max = this.currentStroke.getMaxPoint();
                    canvas.redraw((int)min.X, (int)min.Y, (int)(max.X - min.X), (int)(max.Y - min.Y), true);
                    canvas.update();
                } else if (currentTouch.state == 4) {
                    this.currentStroke = this.currentTouchStrokes.get(currentTouch.id);
                    if (this.currentStroke != null) {
                        int temp = this.strokes.indexOf(this.currentStroke);
                        this.currentStroke.addPoint(new Point(currentTouch.x - canvasOrigin.x, currentTouch.y - canvasOrigin.y));
                        this.strokes.remove(temp);
                        this.strokes.add(this.currentStroke);
                        this.currentStroke = null;
                        this.touchDown = false;
                        this.timerOffset = 0;
                    }
                }
                ++i;
            }
        }
    }

    public void mouseDown(MouseEvent event) {
        if (!this.touch && !this.gesture && event.button == 1 && (event.stateMask & SWT.MODIFIER_MASK) != 0) {
            this.timerStart(55L);
            this.mouseDown = true;
            this.timerOffset = 0;
            this.currentMouseStroke = new Stroke();
            this.currentMouseStroke.addPoint(new Point(event.x, event.y));
        }
    }

    public void mouseUp(MouseEvent event) {
        if (!this.touch && !this.gesture) {
            this.mouseDown = false;
            if (this.currentMouseStroke == null) {
                return;
            }
            if (this.strokes.isEmpty() || this.newStroke) {
                this.newStroke = true;
                this.strokes.add(this.currentMouseStroke);
                this.currentMouseStroke.clearStroke();
                this.currentMouseStroke = null;
                FigureCanvas canvas = (FigureCanvas)this.getGraphicalControl();
                canvas.redraw();
                canvas.update();
            } else {
                int indexOfLastStroke = this.strokes.size() - 1;
                this.strokes.get(indexOfLastStroke).addNewPartOfStroke(this.currentMouseStroke);
                this.newStroke = true;
                this.currentMouseStroke.clearStroke();
                this.currentMouseStroke = null;
                FigureCanvas canvas = (FigureCanvas)this.getGraphicalControl();
                canvas.redraw();
                canvas.update();
            }
            this.timerOffset = 0;
        }
    }

    public void mouseMove(MouseEvent event) {
        if (!this.touch && !this.gesture && this.mouseDown) {
            this.currentMouseStroke.addPoint(new Point(event.x, event.y));
            Point min = this.currentMouseStroke.getMinPoint();
            Point max = this.currentMouseStroke.getMaxPoint();
            FigureCanvas canvas = (FigureCanvas)this.getGraphicalControl();
            if (canvas != null) {
                canvas.redraw((int)min.X, (int)min.Y, (int)(max.X - min.X), (int)(max.Y - min.Y), true);
                canvas.update();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    private void deleteStrokes(BasicGesture basicGesture) {
        HashSet<Stroke> delStrokes = new HashSet<Stroke>();
        delStrokes.addAll(basicGesture.getStrokes());
        for (Stroke stroke : delStrokes) {
            if (!this.strokes.contains(stroke)) continue;
            this.strokes.remove(stroke);
            this.findBasicGestures.remove(basicGesture);
        }
    }

    private void timerStart(long intervall) {
        if (this.timer == null) {
            this.timer = new Timer();
            timertask = new TimerTask(){

                @Override
                public void run() {
                    Editor.this.inputProcessing();
                }
            };
            this.timer.schedule(timertask, 0L, intervall);
        }
    }

    public void inputStopp() {
        if (this.timer != null) {
            if (this.strokes.size() > 0) {
                List<BasicGesture> finishedGestures = this.preProcessor.process(this.strokes);
                int i = 0;
                while (i < finishedGestures.size()) {
                    BasicGesture finishedGesture = finishedGestures.get(i);
                    Result result = this.recognizer.staticRecognize(finishedGesture);
                    this.deleteStrokes(finishedGesture);
                    this.doSomething(result);
                    ++i;
                }
            }
            this.preProcessor.clear();
            this.recognizer.setProcessingStep(0);
            this.strokes.clear();
            timertask.cancel();
            this.timer.cancel();
            timertask = null;
            this.timer = null;
            this.touch = false;
            this.mouse = false;
            this.gesture = false;
            if (this.currentStroke != null) {
                this.currentStroke.clearStroke();
            }
            this.currentTouchStrokes.clear();
        }
    }

    public void inputProcessing() {
        ++this.timerOffset;
        this.recognizer.setProcessingStep(this.recognizer.getProcessingStep() + 1);
        if ((this.touchDown || this.mouseDown) && this.timerOffset >= 7) {
            this.timerOffset = 0;
            if (this.strokes.isEmpty() || this.newStroke) {
                this.newStroke = false;
                if (this.mouseDown) {
                    this.strokes.add(this.currentMouseStroke);
                }
            } else {
                int indexOfLastStroke = this.strokes.size() - 1;
                if (this.mouseDown) {
                    this.strokes.get(indexOfLastStroke).addNewPartOfStroke(this.currentMouseStroke);
                }
            }
            try {
                recDelSemaphore.acquire();
                try {
                    this.preProcessor.setTimerOffset(this.timerOffset);
                    this.preProcessor.setFinishOffset(7);
                    BasicGesture basicGesture = this.preProcessor.preProcess(this.strokes);
                    if (basicGesture.getFinished() && !basicGesture.isContinous()) {
                        Result result = this.recognizer.staticRecognize(basicGesture);
                        this.deleteStrokes(result.getGesture());
                        this.doSomething(result);
                    }
                }
                finally {
                    recDelSemaphore.release();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (!(this.touchDown && this.mouseDown || this.timerOffset < 7)) {
            this.inputStopp();
        }
    }

    private void doSomething(Result result) {
        double matchingScore = 0.8;
        if (result.getRecognitionResult().getScore() == -1.0) {
            System.out.println(">>> Keine Geste erkannt <<<");
        }
        if (result.getRecognitionResult().getScore() > matchingScore) {
            System.out.println();
            System.out.println("Name: " + result.getName());
            System.out.println("    Score: " + result.getScore());
            System.out.println("    Distance: " + result.getDistance() + " Angle: " + result.getAngle());
            System.out.println("    First Point: x " + result.getFirstPoint().X + ", y " + result.getFirstPoint().Y + " LastPoint x:  " + result.getLastPoint().X + " y: " + result.getLastPoint().Y + " Centre x: " + result.getCentreBox().X + " y: " + result.getCentreBox().Y);
            System.out.println();
            for (GestureResultListener listener : this.gestureResultListeners) {
                listener.gestureDetected(result);
            }
        } else {
            System.out.println("<< zu geringer MatchingScore >>");
        }
    }

    public void addGestureResultListener(GestureResultListener g) {
        this.gestureResultListeners.add(g);
    }

    public void removeGestureResultListener(GestureResultListener g) {
        this.gestureResultListeners.remove(g);
    }

    public void paintControl(PaintEvent e) {
        if (this.currentMouseStroke != null) {
            for (Point p : this.currentMouseStroke.getPoints()) {
                e.gc.fillOval((int)p.X, (int)p.Y, 4, 4);
            }
        }
        if (this.currentStroke != null) {
            for (Point p : this.currentStroke.getPoints()) {
                e.gc.fillOval((int)p.X, (int)p.Y, 4, 4);
            }
        }
    }

    public void addXMLGesture(String xmlGesture) {
        if (xmlGesture != null) {
            GestureRecognizer.addGesture(xmlGesture);
        }
    }

    public Hashtable<String, Multistroke> getGestures() {
        return this.recognizer.getGestures();
    }
}

